﻿using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.EntityFrameworkCore.Internal;
using Siger.ApiCommon.Result;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Linq;
using Siger.Middlelayer.TlmRepository.Response;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.Redis.Repositories;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.ApiTLM.Controllers
{
    public class ToolLifeController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;

        public ToolLifeController(IUnitOfWork unitOfWork)
        {
            _unitOfWork = unitOfWork;
        }
        [NoTokenValidateFilter]
        [HttpPost]
        public IActionResult SynMachineCycleUsage([FromBody]RequestSetToolLife request)
        {
            var now = DateTime.Now;
            var helper = new ToolMachineCycleUsageRepository(request.cid, request.pid);
            var tools = new List<ToolMachineCycleUsage>();
            //主轴1
            tools.Add(new ToolMachineCycleUsage
            {
                machine = request.mid.ToStr(),
                alarm = 0,
                cycleTime = 0,
                changeTime = now.ToString(UnixTimeHelper.DateTimeFormat),
                lastTime = now.ToString(UnixTimeHelper.DateTimeFormat),
                pn = request.pn,
                tool = request.tool1.ToInt(),
                spn = request.spn,
                tc = request.tc1.ToInt(),
                spindle = 1,
                tl = 0,
                usage = 0
            });
            //主轴2
            tools.Add(new ToolMachineCycleUsage
            {
                machine = request.mid.ToStr(),
                alarm = 0,
                cycleTime = 0,
                changeTime = now.ToString(UnixTimeHelper.DateTimeFormat),
                lastTime = now.ToString(UnixTimeHelper.DateTimeFormat),
                pn = request.pn,
                tool = request.tool2.ToInt(),
                spn = request.spn,
                tc = request.tc2.ToInt(),
                spindle = 2,
                tl = 0,
                usage = 0
            });
            helper.SetToolUsage(tools);
            var tlmToolDataRepository = new TlmToolDataRepository(request.cid, request.pid);
            tlmToolDataRepository.SetToolData(new SetToolData
            {
                ChannelState = (ChannelState)request.pst.ToInt(),
                Life = request.tc1.ToDouble(),
                Life2 = request.tc2.ToDouble(),
                MID = request.mid,
                Step = request.stn,
                ToolNumber = request.tool1,
                ToolNumber2 = request.tool2,
            });
            return new ObjectResult(CommonEnum.Succefull);
        }
    }
}