﻿using Siger.Middlelayer.Share.ModuleEnum;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Common.Helpers
{
    public class KpiCycleEnumHelper
    {

        public static string CycleTypeText(KpiCycleEnum KpiCycle,int Quater,int Week,DateTime cDate)
        {
            var cycleText = string.Empty;
            switch (KpiCycle)
            {
                case KpiCycleEnum.Year:
                    {
                        cycleText = cDate.Year.ToString();
                        break;
                    }
                case KpiCycleEnum.Quarter:
                    {
                        cycleText = $"{cDate.Year.ToString()}Q{Quater}";
                        break;
                    }
                case KpiCycleEnum.Month:
                    {
                        cycleText = $"{cDate.Year.ToString()}-{cDate.Month.ToString()}";
                        break;
                    }
                case KpiCycleEnum.Week:
                    {
                        cycleText = $"{cDate.Year.ToString()}W{Week}";
                        break;
                    }
                case KpiCycleEnum.Day:
                    {
                        cycleText = cDate.ToString("yyyy-MM-dd"); 
                        break;
                    }
                default:
                    {
                        break;
                    }
            }

            return cycleText;
        }

        /// <summary>
        /// 获取KPI 类型 图标查询时间范围
        /// </summary>
        /// <param name="kpiCycleEnum"></param>
        /// <param name="date"></param>
        /// <returns></returns>
        public static DateTime GetCycleDate(KpiCycleEnum kpiCycleEnum,DateTime date)
        {
            if (date == DateTime.MinValue)
                date = DateTime.Now;
            //只取当年


            #region Remove
            var beginDate = date;
            var days = date.DayOfYear-1;
            switch (kpiCycleEnum)
            {
                case KpiCycleEnum.Year:
                    {
                        beginDate = date.AddYears(-5);
                        break;
                    }
                case KpiCycleEnum.Quarter:
                    {
                        beginDate = date.AddYears(-2);
                        beginDate = FirstDayMoth(beginDate);
                        if (date.Year > beginDate.Year)
                            beginDate = date.AddDays(-days);
                        break;
                    }
                case KpiCycleEnum.Month:
                    {
                        beginDate = date.AddYears(-1);
                        beginDate = FirstDayMoth(beginDate);
                        if (date.Year > beginDate.Year)
                            beginDate = date.AddDays(-days);

                        break;
                    }
                case KpiCycleEnum.Week:
                    {
                        beginDate = date.AddDays(-119);
                        beginDate = FirstDayMoth(beginDate);
                        if (date.Year > beginDate.Year)
                            beginDate = date.AddDays(-days);
                        break;
                    }
                case KpiCycleEnum.Day:
                    {
                        beginDate = date.AddMonths(-1);
                        if (date.Year > beginDate.Year)
                            beginDate = date.AddDays(-days);
                        break;
                    }
            }
           
            
            
            return beginDate;
            #endregion
        }
        public static DateTime FirstDayMoth(DateTime datetime)
        {
            return datetime.AddDays(1 - datetime.Day).Date;
        }
    }
}
