﻿using System;
using System.ComponentModel;

namespace Siger.Middlelayer.Common.ModuleEnum
{
    /// <summary>
    /// Acc module, start from 3000000
    /// </summary>
    public enum AccEnum
    {
        [Description("ACC服务配置加载失败")] LoadCfgFail = 3000000,
        [Description("ACC服务注册Consul失败")] RegConsulFail,
        [Description("工单已经上料完成")] Uploaded,
        [Description("刷入料框号进行报工")] InpuBasketfNumber,
        [Description("报工数量大于框设置最大数量")] ReportTooMax,
        [Description("报工数量大于上料最大数量")] ReportMaxCount,
        [Description("料框正在使用")] BasketfIsUsing,
        [Description("料框无效")] BasketInvali,
        [Description("料框为空")] BasketfIsEmpty,
        [Description("框内数量不足")] BasketfNotEnough,
        [Description("料框容量已满")] BasketIsFull,
        [Description("未找工单")] WrokCodeIsEmpty,
        [Description("工单已完成报工")] WrokCodeIsComplated,
        [Description("请扫描设备二维码")] MachineCodeIsNull,

        [Description("没有有效的模具")] MouldsIsNull,
        [Description("模具已经在线")] MouldsOnline,
        [Description("模具已经下线")] MouldsOffline,
        [Description("模具调试已经结束")] MouldsEndDebug,


        //报表模块--提示信息枚举
        [Description("Category类型错误")] Msg_Category_Err,
        [Description("Category类型未找到")] Msg_Category_Null,
        [Description("Rpt 类型未找到")] Msg_Rpt_Null,

        //报表模块--报表分类信息枚举
        [Description("SN类型")] SN,
        [Description("Rework类型")] Rework,
        [Description("Packing类型")] Packing,

        //报表模块--报表明细信息枚举
        [Description("数据表Sn_List")] Sn_List,
        [Description("数据表Sn_Trace")] Sn_Trace,
        [Description("数据表Sn_TraceDetails")] Sn_TraceDetails,
        [Description("数据表Rework_SnList")] Rework_SnList,
        [Description("数据表Packing_BoxList")] Packing_BoxList,
        [Description("数据表packing_BoxSnlist")] Packing_BoxSnlist,
        [Description("数据表packing_BoxHistory")] Packing_BoxHistory,
        [Description("数量必须大于0")] CountZero,
        [Description("超出设置最大数量")] MaxVailCount,
        [Description("请入修改数量原因")] RemarkForModify,
        [Description("超出每日生成步骤长度")] MaxStepOfDate,
        [Description("工单不一致")] WorkcodeDiff,
        [Description("同一料框数量不一致")] CountDiff,
        [Description("不良率不通过")] NotAllPass,
        [Description("请选择操作人员")] SelectOpUser,
        [Description("设备重复上料")] AlreadyUpload,
        [Description("料框上料锁定")] LockUpload,

        [Description("保持状态")]
        KeepState,
        [Description("客户端推送")]
        ClientMoniterMsg,

        [Description("请求的参数非法")]
        ValidateParamRequest,
        [Description("查询的结果为空")]
        EmtyResult,
        [Description("记录已经存在")]
        ExitsResult,
        [Description("产线不存在")]
        Line_Null,
        [Description("工站不存在")]
        Station_Null,
        [Description("用户不存在")]
        User_Null,
        [Description("仓别不存在")]
        WareHouseID_Null,
        [Description("装箱数量与QTY不匹配")]
        BoxQtyNotMatch,
        [Description("已经入库")]
        HasWareHousing,
        [Description("外箱编号不存在")]
        BoxID_NUll,
        [Description("出库失败")]
        WareHouseOut_Error,
        [Description("出库失败,不满足先进先出条件")]
        WareHouseOutCheck_Error,
        [Description("出库失败,此BoxID已出库")]
        WareHouseOut_HasOut,

        [Description("输入的功能名称不存在")]
        FuncName_Null,
        [Description("输入的功能类型不存在")]
        FuncType_Null,
        [Description("输入的零件类型不存在")]
        CombType_Null,
        [Description("已维护此记录")]
        Data_Exist,
        [Description("新增记录失败")]
        Add_Error,
        [Description("无此记录")]
        Data_Null,
        [Description("请配置抽检站点ID")]
        Data_OQCFC_Null,
        [Description("更新失败")]
        Update_Error,
        [Description("删除失败")]
        Delete_Error,
        [Description("PositionIDNull无效")]
        PositionIDNull,
        [Description("检查项未找到")]
        CheckItemSettingNull,
        [Description("未找到粗材号")]
        CoraseNull,
        [Description("未配置虚拟SN设备对应关系")]
        VirtualCfgNull,
        [Description("未找到虚拟SN号码")]
        Virtual_SN_Notfound,
        [Description("无动平衡数据")]
        Balance_Data_Notfound,
        [Description("SN生成失败")]
        Busi_Create_Sn_Fail,
        [Description("EventNo为空")]
        Busi_EventNo_Null,
        [Description("SN未找到")]
        Busi_SN_Null,
        [Description("工序不对，不能在当前工位生产")]
        Busi_SN_Routing_NG,
        [Description("保存Trace失败")]
        Busi_SaveTrace,
        [Description("保存SN列表失败")]
        Busi_SaveSNlist,
        [Description("SaveTraceDetails失败")]
        Busi_SaveTraceDetails,
        [Description("提交事务失败")]
        Busi_SaveCommit,
        [Description("机加工开始")]
        Busi_Machine_start,
        [Description("开始保存Trace")]
        Busi_SaveTrace_Start,
        [Description("开始保存TraceDetails")]
        Busi_SaveTraceDetails_Start,
        [Description("提交事务")]
        Busi_SaveCommit_Start,
        [Description("已经装箱，请整箱返工")]
        ReworkBoxIDisExist,
        [Description("已经装车，请整车返工")]
        ReworkCarIDisExist,
        [Description(" 找不到可用粗材号")]
        Busi_CoarseNotFound,
        [Description(" 字典粗材号寿命未配置")]
        Busi_CoarseLifeNotFound,
        [Description(" 粗材号库存充足")]
        Busi_CoarseNotEmpty,
        [Description(" 粗材号库存不足 Coarse Is Empty")]
        Busi_CoarseIsEmpty,
        [Description(" 调试件/报废件 不能过站")]
        Busi_DebugWasteSN,
        [Description(" 不能报废")]
        Busi_NotAllowWaste,


        [Description("箱号为空")]
        BoxIdIsNull,

        [Description("箱子已满")]
        BoxIsFull,

        [Description("箱子信息未找到")]
        Packing_Box_Null,

        [Description("箱子SN信息未找到")]
        Packing_Box_SN_Nul,

        [Description("产品信息未找到")]
        ProductInfo_Record_Null,

        [Description("打包不检查SN")]
        Packing_Bon_SN_NoCheck,
        [Description("检验项目未找到")]
        CheckOutItems_Null,

        [Description("状态未找到")]
        RouteStatus_Null,

        [Description("打印机未找到")]
        PrinterNotFound,

        [Description("箱号排序规则未找到")]
        NumberRuleNotFound,

        [Description("车号信息未找到")]
        CarNotFound,

        [Description("该箱号无需补刷")]
        BoxNotNeedPackAdd,

        [Description("该车号必须先满车")]
        CarIDFullError,
        [Description("数量")]
        CheckCarSNStatusQTY,
        [Description("SN状态不对")]
        CheckCarSNStatus,
        [Description("具有较早记录未完成")]
        HasEarlyData,

        [Description("未配置Machine对应关系")]
        Machine_Mapping_Null,
        [Description("未找到匹配的MongoDB数据")]
        Machine_MongoDbRecord_Null,
        [Description("保存机加工数据失败")]
        Machine_SaveRecord_Fail,
        [Description("保存机加工成功")]
        Machine_SaveRecord_Ok,
        //基础配置同步=======================================
        [Description("同步配置")]
        Sync_PHP_Cfg_Success,
        [Description("同步ProductInfo配置失败")]
        Sync_Fail_Product_Info,
        [Description("同步Line配置失败")]
        Sync_Fail_Line,
        [Description("同步Station配置失败")]
        Sync_Fail_Station,
        [Description("同步Position配置失败")]
        Sync_Fail_Position,
        [Description("同步Shift配置失败")]
        Sync_Fail_Shift,
        [Description("同步LineUser配置失败")]
        Sync_Fail_LineUser,


        [Description("同步PHP地址无效")]
        Sync_Cfg_Url,

        [Description("自动出炉成功")]
        Auto_FurnaceOut_Success,

        [Description("自动出炉失败")]
        Auto_FurnaceOut_Failed,

        [Description("登录用户无效")]
        Login_User_Null,
        [Description("登录密码无效")]
        Login_User_Pwd_Erro,
        [Description("角色未配置")]
        Login_User_Role_Null,
        [Description("角色菜单权限未配置")]
        Login_User_Role_Menu_Null,
        //打标异常============================================
        [Description("Sn信息已存在")]
        Duplicate_Sn,
        [Description("筐内零件已满")]
        BasketSn_Full,
        [Description("零件已装配")]
        PartSn_Null,
        [Description("工单数量达标")]
        Workorder_Quantity_Full,
        [Description("筐内零件删除")]
        BasketSn_Delete,
        [Description("钩上无零件")]
        BasketSn_No_Data,
        [Description("没有配置开关信息")]
        BaseItem_No_Data,


        [Description("无筐信息")]
        Basket_No_Data,
        [Description("非工单/非料框信息")]
        Number_Error,
        [Description("料框打标锁定")]
        Basket_BindLabel_Lock,
        [Description("首件检验未完成")]
        No_First_Check,
        [Description("首件个数不超过1")]
        More_Then_One,

        [Description("不能撤销已经报工的上料记录")]
        ExitsCharging,
        [Description("需要扫描新框")]
        NeedNewBasketNumber,
        [Description("密码无效")]
        PwdInValid,
        [Description("产线层级不满足")]
        LevelInvalid,
        [Description("字典未设置打包期限")]
        PackingDayNotSeting,
        [Description("超过打包期限")]
        PackingDayInvali,
        [Description("Sn无效")]
        SNInvalidte,
        [Description("当前工位不能使用这个程序")]
        CanNotUseThisProgram,
        [Description("时间冲突")]
        ErrorDate,
        [Description("未配置报表路由")]
        RouteRptIsEmpty,
        [Description("报工数大于实际工单数量")]
        MoreThanWorkQty,
        [Description("请扫描工单获取工艺")]
        ProductRouteMissing,

        [Description("辅料数量超出")]
        AssembNumberOut,
        [Description("请选中后打印")]
        AssembPrint,
        [Description("订单类型未找到")]
        OrderTypeMiss,
        [Description("该订单类已生成Sn")]
        AlreadyCreateSn,
        [Description("文件类型错误")]
        FileTypeError,
        [Description("序号规则未配置")]
        SerinumCfgEmpty,
        [Description("序号已全部生成")]
        SerinumFull,
        [Description("该任务状态已经完成")]
        AutoTaskDone,
        [Description("产线模式未找到")]
        LineModeNotfound,
        [Description("设备状态不可用")]
        MachineDisable,
        [Description("设备正在使用中")]
        MachineBusy,
        [Description("任务进行中")]
        TaskProcessing,
        [Description("产品工装未找到")]
        FixtureToolsIsNone,
        [Description("未找到工装信息")]
        FixtureOrderNulll,
        [Description("设备正在空闲中")]
        MachineOnFree,
        [Description("设备已经生产完成")]
        MachineProCompalate,
        [Description("该设备当前无工装状态")]
        MonitorNotfound

    }
    public enum SeriNumCfg
    {
        [Description("固定码")]
        NORMAL = 0,
        [Description("日期码")]
        DATE = 1,
        [Description("顺序码")]
        SeriNum = 2,
        [Description("替换码")]
        Replace = 3,
        [Description("校验码")]
        Code = 4
    }
    public enum BuilderType
    {
        [Description("序列号规则")]
        Sn = 0,
        [Description("箱号规则")]
        Box = 1

    }

    public enum Packing_Status
    {
        /// <summary>
        /// 满箱
        /// </summary>
        FullBox = 1,

        /// <summary>
        /// 临时满箱
        /// </summary>
        TempBox,

        /// <summary>
        /// 待满箱，该状态下才可以补刷
        /// </summary>
        WaitForFullBox,

        /// <summary>
        /// 清空
        /// </summary>
        Clear
    }
    public enum Type_Status
    {
        /// <summary>
        /// 工单
        /// </summary>
        [Description("工单")]
        workCode = 1,
        /// <summary>
        /// 料框
        /// </summary>
        [Description("料框")]
        basket = 2,
        /// <summary>
        /// 模具
        /// </summary>
        [Description("模具")]
        moulds = 3,
        /// <summary>
        /// 箱子
        /// </summary>
        [Description("箱子")]
        box = 4,
        [Description("设备")]
        machine = 5

    }
    public enum MachineChange_Status
    {
        [Description("更换上料")]
        Change = 1
    }
    public enum Box_Status
    {
        [Description("箱子")]
        parent = 1,
        [Description("箱子物件")]
        child = 2,
        [Description("临时出货")]
        outNotpacking = 3
    }
    public enum Basket_Status
    {
        /// <summary>
        ///上料
        /// </summary>
        [Description("上料")]
        upload = 1,
        /// 报工
        /// </summary>
        [Description("报工")]
        report = 2,
        /// <summary>
        /// 转框
        /// </summary>
        [Description("转框")]
        Change = 3,
        [Description("修改")]
        Modify = 4,
        [Description("检验")]
        QC = 5,

        [Description("取消上料")]
        CancelUpload = 10,
    }

    public enum BasketRate_Status
    {

        [Description("不通过")]
        NotAllow = 0,
        [Description("通过")]
        Pass = 1
    }
    public enum BasketPosition_Status
    {
        [Description("被更换/撤销上料")]
        Deleted = 0,
        [Description("正常")]
        validate = 1,
        [Description("完成")]
        isComplated = 2
    }

    /// <summary>
    /// 料框状态枚举
    /// </summary>
    public enum BasketList_Status
    {
        [Description("正常")]
        Normal = 1,
        [Description("上料锁定")]
        UploadLock = 2,
        [Description("打标锁定")]
        BindLabelLock
    }
    public enum BasketChange_Status
    {
        [Description("转入")]
        Change_In = 2,
        [Description("剩余")]
        Change_Res = 3
    }
    public enum Moulds_Status
    {
        [Description("模具上线")]
        upload = 1,
        [Description("模具下线")]
        down = 2,
        [Description("调试开始")]
        debugBegin = 3,
        [Description("调试结束")]
        debugEnd = 4
    }
    public enum CncPlan_Status
    {
        /// <summary>
        /// 未排产
        /// </summary>
        defult = 0,
        /// <summary>
        /// 已排产
        /// </summary>
        plan = 1,
        /// <summary>
        /// 生产中
        /// </summary>
        production = 2,
        /// <summary>
        /// 已完成
        /// </summary>
        complated = 3
    }

    /// <summary>
    /// BaseItem 站别自定义功能枚举
    /// </summary>
    public class BaseItem
    {
        /// <summary>
        ///  自定义功能 常量  对应Tbl_Station_Base_Setting_Item 
        ///  新增功能时 插入DB 并添加对应常量
        /// </summary>
        public const string TraceCheck = "追溯功能";
        public const string PackingCheck = "打包功能";

        /// <summary>
        /// Trace功能枚举
        /// </summary>
        public enum TraceItemEnum
        {
            [Description("机加工数据没有SN")]
            Machine_No_Sn = 1,
            [Description("不检查SN")]
            NotCheckSN = 2
        }
        /// <summary>
        /// Packing功能枚举
        /// </summary>
        public enum PackingItemEnum
        {
            [Description("打包不检查过站")]
            NotCheckRouting = 1
        }
    }

    /// <summary>
    /// BlockAndSticky模块中使用
    /// </summary>
    public enum Dict
    {
        FuncName,    //功能名称
        FuncType,   //功能类型
        CombType,   //零件类型
        Region, //出货地
        Item, //检查项
    }

    /// <summary>
    /// 过站结果枚举
    /// </summary>
    public enum EvenNoEnum
    {
        [Description("默认")]
        Default,
        [Description("OK")]
        OK = 1,
        [Description("NG")]
        NG = 2,
        [Description("工废")]
        PieceScrapped,
        [Description("料废")]
        MaterialScrapped
    }

    #region 对应配置在字典表中的数据,字典表的数据更改，这里也要改
    /// <summary>
    /// 工单类型
    /// </summary>
    public enum WorkorderCategory_Status
    {
        [Description("成品")]
        Finished = 1,

        [Description("半成品")]
        Unfinished = 2,

        [Description("返工")]
        Rework = 3
    }
    /// <summary>
    /// 返工工单设置功能
    /// </summary>
    public enum WorkorderFunction_Status
    {
        [Description("Delete BoxID")]
        DeleteBoxID = 1,

        [Description("Delete CarID")]
        DeleteCarID = 2,

        [Description("Delete Battery")]
        DeleteBattery = 3,

        [Description("Delete HDD")]
        DeleteHDD = 4
    }
    /// <summary>
    /// 出入站结果
    /// </summary>
    public enum EventNo_Status
    {
        [Description("成功")]
        Success = 1,

        [Description("失败")]
        Fail = 2
    }

    /// <summary>
    /// 填值打勾
    /// </summary>
    public enum CheckType_Status
    {
        [Description("打钩")]
        O = 1,

        [Description("填值")]
        V = 2
    }
    #endregion

    #region SigerTrBaseSetting中SEQ的枚举类
    public enum BaseSettingEnum
    {
        TrackMachine = 1,
        TrackNoSn = 2,
        TraceMongoDBSN = 3,
        SaveCoarse = 4,
        SaveVSN = 5,
        NoCollectionMachineState = 6,
        SaveResultCreateSn = 7,
        UseCoarseLifeCreaetSn = 8,
        NotAllowDebugSn = 9,
        CreateSNbeforeSaveTrace = 10,
        ClearDataCollection = 11,
        GetSectionID = 12,
        TrackNoFirstCheck = 14
    }
    #endregion

    public enum ReworkCategory
    {
        Sn,
        DeleteCarId,
        RetainCarId,
        DeleteBoxId,
        RetainBoxId
    }

    /// <summary>
    /// 机加工 
    /// </summary>
    public enum ConstEnum
    {
        /// <summary>
        /// 解锁密码的id
        /// </summary>
        [Description("1001")]
        UnlockPSW,
        /// <summary>
        /// 机加工解锁插入的特殊SN
        /// </summary>
        [Description("1234567890")]
        UnlockSN,

        /// <summary>
        /// 机加工解锁时插入tr_sn_list中的特殊PN
        /// </summary>
        [Description("000000")]
        UnlockPN,

        /// <summary>
        /// 机加工解锁时插入tr_sn_list中的特殊id
        /// </summary>
        [Description("000000")]
        UnlockProductID,
    }

    public enum PartStatus
    {
        [Description("正在装配")]
        InComplete = 1,
        [Description("装配完成")]
        Complete = 2
    }

    public enum PackStatus
    {
        /// <summary>
        /// 满箱
        /// </summary>
        FullBox = 1,

        /// <summary>
        /// 临时满箱
        /// </summary>
        TempBox,

        /// <summary>
        /// 待满箱，该状态下才可以补刷
        /// </summary>
        WaitForFullBox,

        /// <summary>
        /// 清空
        /// </summary>
        Clear
    }
    /// <summary>
    /// 站别功能
    /// </summary>
    public enum BaseSetting
    {
        /// <summary>
        /// 机加工无 根据时间段收集机加工- 六丰
        /// </summary>
        [Description("根据时间段收集机加工 无SN")]
        TrackMachineDatawithTime = 1,
        /// <summary>
        /// 不更新当前过站状态 CVT1
        /// </summary>
        [Description("不更新当前过站状态")]
        TrackNotChk_SN,
        /// <summary>
        /// 保存Trace时当前工站 真实SN机加工数据 CVT1 线
        /// </summary>
        [Description("保存Trace时当前工站 真实SN机加工数据")]
        MachineDataWithSaveTrace,
        /// <summary>
        /// 打标刻印SN时保存粗材号
        /// </summary>
        [Description("打标SN时保存粗材号")]
        Station_SaveCoarse,
        /// <summary>
        /// CreateSn时根据虚拟SN 收集当前工站之前机加工数据
        /// </summary>
        [Description("CreateSn时根据虚拟SN 收集当前工站之前机加工数据")]
        MachineData_With_Vsn,
        /// <summary>
        /// CollectionMachineState
        /// </summary>
        [Description("收集非机加工设备状态")]
        CollectionMachineState,
        /// <summary>
        /// 生成SN 时保存粗材数据 OP10,OP20 粗材
        /// </summary>
        [Description("生成SN 时保存粗材数据")]
        SaveResultCreateSn,
        /// <summary>
        /// 刻印检查粗材寿命
        /// </summary>
        [Description("刻印检查粗材寿命")]
        UseCoarseLifeCreaetSn,
        /// <summary>
        /// 调试工件 不能过站
        /// </summary>
        [Description("调试/报废工件不能过站")]
        NotAllowDebugSn,
        /// <summary>
        /// 保存过站信息前先创建SN
        /// </summary>
        [Description("保存过站信息前先创建SN")]
        CreateSNbeforeSaveTrace,
        /// <summary>
        /// 收集清洗机数据
        /// </summary>
        [Description("收集清洗机数据")]
        ClearDataCollection,

        /// <summary>
        /// 打包检查过期时间
        /// </summary>
        [Description("打包检查过期时间")]
        EnalbePackingCheckDay,
        /// <summary>
        ///保存TraceInfor时 真实SN 收集当前工站之前机加工数据
        /// </summary>
        [Description("保存TraceInfor时 真实SN 收集当前工站之前机加工数据")]
        CollectMachineData,
        /// <summary>
        /// 收集动平衡数据
        /// </summary>
        [Description("收集动平衡数据")]
        CollectBalanceData,
        /// <summary>
        /// VSN 设备 (对于5,13 生效的设备)
        /// </summary>
        [Description("VSN设备")]
        VSN_OF_Machine,
        /// <summary>
        /// Balance设备(对于14 的设备)
        /// </summary>
        [Description("Balance设备")]
        Balance_OF_Machine,
        /// <summary>
        /// 打标刻印 收集打标前op10,op20工艺组 机加工
        /// </summary>
        [Description("打标刻印 收集打标前关联工艺组 机加工")]
        Combo_Routing_Machine,
        /// <summary>
        /// 工艺组1 设备
        /// </summary>
        [Description("工艺组1")]
        Combo_One_Machine,
        /// <summary>
        /// 工艺组2 设备
        /// </summary>
        [Description("工艺组2")]
        Combo_Two_Machine,

        /// <summary>
        /// 取消报工前首检
        /// </summary>
        [Description("取消报工前首检")]
        Cancel_InspectionFirst,
    }

    public enum SerialCfgType
    {
        [Description("二维码")]
        SN = 1,
        [Description("箱号")]
        BOX = 2
    }
  
    public enum PrintLabeTable
    {
        [Description("siger_tr_sn_list")]
        SNList = 1,
        [Description("siger_tr_pack_box_list")]
        PackBoxlist = 2
    }

    public enum SnList
    {
        /// <summary>
        /// 序列号二维码信息
        /// </summary>
        SN,

        /// <summary>
        /// 产品id
        /// </summary>
        ProductId,

        /// <summary>
        /// 产品编号
        /// </summary>
        ProductCode,

        /// <summary>
        /// 产线ID，产线结构倒数第二层
        /// </summary>
        Line,

        /// <summary>
        /// 工单类型
        /// </summary>
        WoType,

        /// <summary>
        /// 工单号
        /// </summary>
        WO,

        /// <summary>
        /// 物料ID
        /// </summary>
        MaterialId,

        /// <summary>
        /// SN解析PN
        /// </summary>
        PN,

        /// <summary>
        /// 过站状态码
        /// </summary>
        ResultStatus,

        InputDateTime,

        TransDateTime,

        /// <summary>
        /// 数量
        /// </summary>
        printCount
    }

    public enum PackBoxList
    {
        /// <summary>
        /// 箱号ID
        /// </summary>
        BoxID,

        Region,

        FullQty,

        IP,

        UID,

        TransDateTime
    }
   
}
