﻿using System.ComponentModel;

namespace Siger.Middlelayer.Common.ModuleEnum
{
    /// <summary>
    /// Config module, start from 2000000
    /// </summary>
    public enum ConfigEnum
    {
        [Description("用户名或密码错误")]
        LoginError = 2000000,

        [Description("重新登录信息不正确")]
        ReLoginFailed,
        [Description("用户未找到")]
        UserNotFound,
        [Description("项目用户未找到")]
        ProjectUserNotFound,
        [Description("项目未找到")]
        ProjectNotFound,
        [Description("Token未找到")]
        TokenIsEmpty,
        [Description("登出信息未找到")]
        EncryptedDataIsEmpty,
        [Description("登出失败")]
        LogoutFailed,
        //file operation
        [Description("文件名未找到")]
        FileNameIsEmpty = 2010000,
        [Description("下载目录未找到")]
        DirectoryNotFound,
        [Description("模板文件未找到")]
        TemplateFileNotFound,
        [Description("模板文件未配置")]
        TemplateFileNotConfig,

        [Description("上传文件为空")]
        UploadFileNotFound,
        [Description("上传的不是Excel文件")]
        IsNotExcelFile,
        [Description("导入失败")]
        ImportFailed,
        [Description("获取用户信息失败")]
        GetTokenInfoError,  //登录时redis中存储的pid、uid

        [Description("产线层级为空")]
        UserLevelNull,
        [Description("已绑定子系统或部件")]
        MachineAlreadyBind,
        [Description("设备属性未找到")]
        MachineAttributionNotFound,
        [Description("设备未找到")]
        MachineNotFound,
        [Description("导入的设备属性不正确")]
        MachineAttributionError,
        [Description("当前设备属性不能重复导入")]
        MachineAttributionInvalid,
        [Description("父级设备未找到")]
        ParentMachineNotFound,
        [Description("工站未找到")]
        StationNotFound,
        [Description("当前设备无法触发安灯")]
        AndonCanNotTrigger,
        [Description("当前设备已绑定工位，无法删除")]
        MahcineCanNotDelete,
        [Description("物料不存在父级")]
        PnParentNotfound,
    }

    public enum ClientType
    {
        [Description("西格数据刀具报警管理系统")]
        Lamp = 1,
        [Description("西格数据线边柜管理系统")]
        TlmStorage
    }

    public enum MachineCategory
    {
        [Description("NC设备")]
        NC = 1,

        [Description("非NC设备")]
        NNC
    }
    public enum MachineNodeName
    {
        [Description("入固")]
        Create = 1,
        [Description("维修")]
        Repair,
        [Description("维护")]
        Maintenance,
        [Description("移动")]
        Move,
        [Description("委外")]
        Outsourcing,
        [Description("报废")]
        Scrap,
        [Description("其他")]
        Other,
    }
    public enum ComboxItem
    {
        [Description("产品")]
        Product =1,
        [Description("物料")]
        Material =2
    }
}