﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Siger.Middlelayer.Share.ModuleEnum
{
    public enum KpiCycleEnum
    {
        [Description("年")]
        Year=1,
        [Description("季")]
        Quarter,
        [Description("月")]
        Month,
        [Description("周")]
        Week,
        [Description("日")]
        Day,
    }
    public enum KpiCondition
    {
        [Description("实际值>目标值")]
        Large,
        [Description("实际值<目标值")]
        Less,
        [Description("实际值>=目标值")]
        LargeEq,
        [Description("实际值<=目标值")]
        LessEq,
    }
    public enum KpiTaskResult
    {
        /// <summary>
        /// 未维护
        /// </summary>
        [Description("未维护")]
        NoConfg=1,
        /// <summary>
        /// 异常
        /// </summary>
        [Description("异常")]
        Exception,
        /// <summary>
        /// 正常
        /// </summary>
        [Description("正常")]
        Normal
    }
    public enum KpiExecption
    {
        /// <summary>
        /// 异常 待处理
        /// </summary>
        [Description("待处理")]
        Default=1,
        /// <summary>
        /// 异常 处理中
        /// </summary>
        [Description("处理中")]
        Processing,
        /// <summary>
        /// 异常 处理完成
        /// </summary>
        [Description("处理完成")]
        Complated
    }
    public enum KpiTaskType
    {
        [Description("正常")]
        Normal =0,
        [Description("异常")]
        Exception =1
    }
    public enum KpiUpdValue
    {
        [Description("实际值")]
        Actval =0,
        [Description("备注")]
        Remark =1,
        [Description("目标值")]
        TartgetVal =2,
        [Description("增加值")]
        AddVal =3
    }

    public enum KpiPushSettingLevel
    {
        /// <summary>
        /// 第一级
        /// </summary>
        [Description("第一级")]
        First =1,
        /// <summary>
        /// 第二级
        /// </summary>
        [Description("第二级")]
        Second =2,
        /// <summary>
        /// 第三级
        /// </summary>
        [Description("第三级")]
        Three =3,
        /// <summary>
        /// 第四级
        /// </summary>
        [Description("第四级")]
        Four =4
    }
    public enum KpiPushSettingType
    {
        /// <summary>
        /// 异常 
        /// </summary>
        [Description("异常未处理")]
        Exception = 1,

        /// <summary>
        /// 已指定计划
        /// </summary>
        [Description("异常已指定计划")]
        Processing =2,
        /// <summary>
        /// 已处理( 未解决/已解决)
        /// </summary>
        [Description("异常处理结果")]
        Done =3,


    }
    public enum KpiMsgPushType
    {
        /// <summary>
        /// 未触发
        /// </summary>
        [Description("未触发")]
        None =0,
        /// <summary>
        /// 已触发
        /// </summary>
        [Description("已触发")]
        Done =1
    }
    public enum KpiAutoRelationInterval
    {
        [Description("天")]
        Day =1,
        [Description("周")]
        Week =2,
        [Description("月")]
        Month =3,
        [Description("季")]
        Quarter =4,
        [Description("年")]
        Year =5
    }
}
