﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Siger.Middlelayer.Common.ModuleEnum
{
    public enum WMSEnum
    {
        /// <summary>
        /// 供应商
        /// </summary>
        Business=1,
        /// <summary>
        /// 客户
        /// </summary>
        Customer
    }

    /// <summary>
    /// 出入库类型
    /// </summary>
    public enum WaveHouseType
    {
        /// <summary>
        /// 入库
        /// </summary>
        In = 1,
        /// <summary>
        /// 出库
        /// </summary>
        Out = 2
    }
    /// <summary>
    /// 出入库类别:原材入库等
    /// </summary>
    public enum WaveHousingType
    {
        /// <summary>
        /// 原材入库
        /// </summary>
        [Description("原材入库")]
        RawMaterial = 1,
        /// <summary>
        /// 生产入库
        /// </summary>
        [Description("生产入库")]
        Production,
        /// <summary>
        /// 其他入库
        /// </summary>
        [Description("其他入库")]
        Other,

        /// <summary>
        /// 生产领料
        /// </summary>
        [Description("生产领料")]
        ProductionOut,

        /// <summary>
        /// 销售出货
        /// </summary>
        [Description("销售出货")]
        SalesOut,
        /// <summary>
        /// 其他出库
        /// </summary>
        [Description("其他出库")]
        OtherOut,

        /// <summary>
        /// 整刀入库
        /// </summary>
        [Description("整刀入库")]
        WholeToolIn,

        /// <summary>
        /// 采购入库
        /// </summary>
        [Description("采购入库")]
        Purchase,
        /// <summary>
        /// 回收入库
        /// </summary>
        [Description("回收入库")]
        Recycling,

        /// <summary>
        /// 领用出库
        /// </summary>
        [Description("领用出库")]
        UseOut 
    }
    public enum WaveHousingState
    {
        /// <summary>
        /// 待审核
        /// </summary>
        [Description("待审核")]
        Waiting=1,
        /// <summary>
        /// 审核通过
        /// </summary>
        [Description("审核通过")]
        Checked,
        /// <summary>
        /// 审核未通过
        /// </summary>
        [Description("审核未通过")]
        Failed,
        /// <summary>
        /// 入库中
        /// </summary>
        [Description("入库中")]
        WaveHousing,
        /// <summary>
        /// 入库完成
        /// </summary>
        [Description("入库完成")]
        Finish,
        /// <summary>
        /// 出库中
        /// </summary>
        [Description("出库中")]
        WaveHousingOut,
        /// <summary>
        /// 出库完成
        /// </summary>
        [Description("出库完成")]
        WaveHousingOutFinish,
        /// <summary>
        /// 删除
        /// </summary>
        [Description("删除")]
        Deleted
    }
    public enum Settings
    {
        /// <summary>
        /// 入库单号前缀
        /// </summary>
        WaveHousingPre,

        /// <summary>
        /// 出库单号前缀
        /// </summary>
        WaveHouseOutPre,

        /// <summary>
        /// 调拨单号前缀
        /// </summary>
        AllocationPre,

        /// <summary>
        /// 系统批次前缀
        /// </summary>
        SystemBatchPre,

        /// <summary>
        /// 入库是否打印批次号
        /// </summary>
        WaveHousingPrintBatch,

        /// <summary>
        /// 入库是否打印批次号份数
        /// </summary>
        WaveHousingPrintBatchCount,

        /// <summary>
        /// 入库是否打印序号
        /// </summary>
        WaveHousingPrintNo,

        /// <summary>
        /// 入库是否打印序号份数
        /// </summary>
        WaveHousingPrintNoCount,

        /// <summary>
        /// 出库是否打印批次号
        /// </summary>
        WaveHouseOutPrintBatch,

        /// <summary>
        /// 出库是否打印批次号份数
        /// </summary>
        WaveHouseOutBatchCount,

        /// <summary>
        /// 盘点单前缀
        /// </summary>
        CheckPre,


        /// <summary>
        /// 用作生成序号的类型
        /// </summary>
        SN,
    }
    /// <summary>
    /// 物料管理模式
    /// </summary>
    public enum managemodel
    {
        /// <summary>
        /// 批次
        /// </summary>
        [Description("批次")]
        Batch =1,
        /// <summary>
        /// 序号
        /// </summary>
        [Description("序号")]
        No,
        /// <summary>
        /// 批量
        /// </summary>
        [Description("批量")]
        Group
    }
    public enum traceType
    {
        /// <summary>
        /// 入库
        /// </summary>
        [Description("入库")]
        WaveHousing =1,
        /// <summary>
        /// 出库
        /// </summary>
        [Description("出库")]
        WaveHousingOut,
        
        /// <summary>
        /// 领用
        /// </summary>
        [Description("领用")]
        Use,

        /// <summary>
        /// 归还
        /// </summary>
        [Description("归还")]
        Return,

        /// <summary>
        /// 库内位置变更
        /// </summary>
        [Description("库内位置变更")]
        LocationChange,

        /// <summary>
        /// 库存调整
        /// </summary>
        [Description("库存调整")]
        StockChange,

        /// <summary>
        /// 盘点
        /// </summary>
        [Description("盘点")]
        Check,

        /// <summary>
        /// 调拨接收
        /// </summary>
        [Description("调拨接收")]
        AllocationReceive,

        /// <summary>
        /// 调拨发出
        /// </summary>
        [Description("调拨发出")]
        Allocation

    }
    public enum StockEnum
    {
        /// <summary>
        /// 在库
        /// </summary>
        InWavehouse,
        /// <summary>
        /// 出库
        /// </summary>
        OutWavehouse,
        /// <summary>
        /// 领用
        /// </summary>
        Use,
        /// <summary>
        /// 调拨中
        /// </summary>
        Allocation,

        /// <summary>
        /// 已调拨至其他位置
        /// </summary>
        Allocationed,
    }
    public enum UseType
    {
        /// <summary>
        /// 归还
        /// </summary>
        SendBack,
        /// <summary>
        /// 领用
        /// </summary>
        Use,
        
    }

    public enum DictUnitType
    {
        meterunits,
        convunits
    }

    /// <summary>
    /// 盘点单状态
    /// </summary>
    public enum CheckStatu
    {
        /// <summary>
        /// 待审核
        /// </summary>
        [Description("待审核")]
        Waitting = 1,

        /// <summary>
        /// 审核通过
        /// </summary>
        [Description("审核通过")]
        Checked,

        /// <summary>
        /// 盘点中
        /// </summary>
        [Description("盘点中")]
        Checking,

        /// <summary>
        /// 盘点完成
        /// </summary>
        [Description("盘点完成")]
        Finish,

        /// <summary>
        /// 取消
        /// </summary>
        [Description("取消")]
        Canceled,

        /// <summary>
        /// 审核未通过
        /// </summary>
        [Description("审核未通过")]
        Failed,

    }

    public enum CheckedStatu
    {
        /// <summary>
        /// 盘盈
        /// </summary>
        [Description("盘盈")]
        MORE,

        /// <summary>
        /// 盘亏
        /// </summary>
        [Description("盘亏")]
        LESS,

        No,
    }

    /// <summary>
    /// 调拨状态
    /// </summary>
    public enum AlloactionStatu
    {
        /// <summary>
        /// 待审核
        /// </summary>
        [Description("待审核")]
        Waitting = 1,

        /// <summary>
        /// 审核通过
        /// </summary>
        [Description("审核通过")]
        Checked,

        /// <summary>
        /// 待调拨
        /// </summary>
        [Description("待调拨")]
        Alloaction,

        /// <summary>
        /// 调拨中
        /// </summary>
        [Description("调拨中")]
        Alloactioning,

        /// <summary>
        /// 待接收
        /// </summary>
        [Description("待接收")]
        WaittingReceiving,

        /// <summary>
        /// 接收中
        /// </summary>
        [Description("接收中")]
        Receiving,

        /// <summary>
        /// 调拨完成
        /// </summary>
        [Description("调拨完成")]
        Finish,

        /// <summary>
        /// 取消
        /// </summary>
        [Description("取消")]
        Canceled,

        /// <summary>
        /// 审核未通过
        /// </summary>
        [Description("审核未通过")]
        Failed,
    }

    public enum SearchType
    {
        /// <summary>
        /// 单号
        /// </summary>
        BILLNUMBER=1,
        /// <summary>
        /// 批次号
        /// </summary>
        BATCH,
        /// <summary>
        /// 料号
        /// </summary>
        INVENTORYPN,
        /// <summary>
        /// 序号
        /// </summary>
        SN
    }

    public enum AlarmInfoType
    {
        /// <summary>
        /// 库存不足
        /// </summary>
        StockAlarm = 1,
    }

    public enum AlarmStatus
    {
        /// <summary>
        /// 未处理
        /// </summary>
        Operating = 1,

        /// <summary>
        /// 已处理
        /// </summary>
        Operated = 2
    }
}
