﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class FixtureToolsCategoryTemplate : ImportBase
    {
        [ExcelColumn("*工装类型")]
        public string Fixture { get; set; }

        [ExcelColumn("上级类型")]
        public string Parent { get; set; }
    }

    public class FixtureToolsTemplate : ImportBase
    {
        [ExcelColumn("*工装类型")]
        public string Catgeory { get; set; }

        [ExcelColumn("*管理类型")]
        public string Manage { get; set; }

        [ExcelColumn("*工装名称")]
        public string Name { get; set; }

        [ExcelColumn("*工装料号")]
        public string PartNumber { get; set; }

        [ExcelColumn("*工装编号")]
        public string Code { get; set; }

        [ExcelColumn("*规格型号")]
        public string Specfication { get; set; }

        [ExcelColumn("*数量")]
        public string Number { get; set; }

        [ExcelColumn("*状态")]
        public string Status { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }

    public class FixtureToolsList : ImportBase
    {
        [ExcelColumn("工装类型")]
        public string Catgeory { get; set; }

        [ExcelColumn("管理类型")]
        public string Manage { get; set; }

        [ExcelColumn("工装名称")]
        public string Name { get; set; }

        [ExcelColumn("工装料号")]
        public string PartNumber { get; set; }

        [ExcelColumn("工装编号")]
        public string Code { get; set; }

        [ExcelColumn("规格型号")]
        public string Specfication { get; set; }

        [ExcelColumn("数量")]
        public string Number { get; set; }

        [ExcelColumn("状态")]
        public string Status { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }

        [ExcelColumn("维护人")]
        public string Updator { get; set; }

        [ExcelColumn("维护时间")]
        public string UpdateTime { get; set; }
    }

    public class FixtureToolsProductTemplate : ImportBase
    {
        [ExcelColumn("*工装名称")]
        public string FixtureTool { get; set; }

        [ExcelColumn("*产品名称")]
        public string Product { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }

    public class FixtureToolsProductList : ImportBase
    {
        [ExcelColumn("工装类型")]
        public string Category { get; set; }

        [ExcelColumn("工装料号")]
        public string PartNumber { get; set; }

        [ExcelColumn("工装名称")]
        public string FixtureTool { get; set; }

        [ExcelColumn("规格型号")]
        public string Specfication { get; set; }

        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }

        [ExcelColumn("产品名称")]
        public string Product { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }

        [ExcelColumn("维护人")]
        public string Updator { get; set; }

        [ExcelColumn("维护时间")]
        public string UpdateTime { get; set; }
    }

    public class FixtureToolsAssmeblyTemplate : ImportBase
    {
        [ExcelColumn("*父工装名称")]
        public string ParentFixtureTool { get; set; }

        [ExcelColumn("*子工装名称")]
        public string FixtureTool { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }

        [ExcelColumn("*状态")]
        public string Status { get; set; }
    }

    public class FixtureToolsAssmeblyList : ImportBase
    {
        [ExcelColumn("父工装类型")]
        public string ParentCategory { get; set; }

        [ExcelColumn("父工装料号")]
        public string ParentPartNumber { get; set; }

        [ExcelColumn("父工装名称")]
        public string ParentFixtureTool { get; set; }

        [ExcelColumn("父工装规格")]
        public string ParentSpecfication { get; set; }

        [ExcelColumn("子工装类型")]
        public string Category { get; set; }

        [ExcelColumn("子工装料号")]
        public string PartNumber { get; set; }

        [ExcelColumn("子工装名称")]
        public string FixtureTool { get; set; }

        [ExcelColumn("子工装规格")]
        public string Specfication { get; set; }

        [ExcelColumn("状态")]
        public string Status { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }

        [ExcelColumn("维护人")]
        public string Updator { get; set; }

        [ExcelColumn("维护时间")]
        public string UpdateTime { get; set; }
    }

    public class AutomationLocationTemplate : ImportBase
    {
        [ExcelColumn("*储位ID")]
        public string LocationId { get; set; }

        [ExcelColumn("*工装名称")]
        public string FixtureTool { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }

    public class AutomationLocationList : ImportBase
    {
        [ExcelColumn("仓库名称")]
        public string Warehouse { get; set; }

        [ExcelColumn("储位信息")]
        public string Location { get; set; }

        [ExcelColumn("储位ID")]
        public string LocationId { get; set; }

        [ExcelColumn("工装类别")]
        public string Catgeory { get; set; }

        [ExcelColumn("工装编号")]
        public string Code { get; set; }

        [ExcelColumn("工装名称")]
        public string Name { get; set; }

        [ExcelColumn("工装规格")]
        public string Specfication { get; set; }

        [ExcelColumn("工件编号")]
        public string SN { get; set; }

        [ExcelColumn("工序顺序")]
        public string RouteNumber { get; set; }

        [ExcelColumn("工序名称")]
        public string RouteName { get; set; }

        [ExcelColumn("物料状态")]
        public string State { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }

        [ExcelColumn("维护人")]
        public string Updator { get; set; }

        [ExcelColumn("维护时间")]
        public string UpdateTime { get; set; }
    }
}
