﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public abstract class ImportResultBase
    {
        
    }

    public class CommonImportResult: ImportResultBase
    {
        public int ret { get; set; }

        public string msg { get; set; }

        public CommonImportResult(int result, string message)
        {
            ret = result;
            msg = message;
        }
    }

    public class ToolImportResult : CommonImportResult
    {
        public IEnumerable<ToolImportInfo> ToolImportInfoes { get; set; }

        public ToolImportResult(int result, string message, IEnumerable<ToolImportInfo> toolImportInfoes) : base(result, message)
        {
            ToolImportInfoes = toolImportInfoes;
        }
    }

    public class ToolImportInfo
    {
        public int MachineId { get; set; }

        public string ProgramNo { get; set; }

        public int RateLife { get; set; }

        public string ToolLocationName { get; set; }

        public string SpindleNo { get; set; }
        public int type { get; set; }
    }

    public class ToolChangeImportResult : CommonImportResult
    {
        public IEnumerable<ToolChangeImportInfo> ToolChangeImportInfoes { get; set; }

        public ToolChangeImportResult(int result, string message, IEnumerable<ToolChangeImportInfo> toolChangeImportInfoes) : base(result, message)
        {
            ToolChangeImportInfoes = toolChangeImportInfoes;
        }
    }

    public class ToolChangeImportInfo
    {
        public int MachineId { get; set; }

        public int ChangeTime { get; set; }

        public int RatedLife { get; set; }

        public string SpindleName { get; set; }

        public string ToolName { get; set; }

        public string ProgramNo { get; set; }

        public string Reason { get; set; }

        public string ToolNo { get; set; }
    }

    public class ImportResult: ImportResultBase
    {
        public int errorExportFileCode { get; set; }

        public int errorNum { get; set; }

        public List<string> errorStrArr { get; set; }

        public string file { get; set; }

        public int successNum { get; set; }

        public Enum msg { get; set; }
    }

    public class ImportSuccessResult: ImportResult
    {
        public ImportSuccessResult(int successCount)
        {
            errorExportFileCode = 0;
            errorStrArr = new List<string>();
            errorNum = 0;
            file = string.Empty;
            successNum = successCount;
            msg = ImportEnum.Succefull;
        }
    }

    public class ImportFailedResult : ImportResult
    {
        public ImportFailedResult(List<string> errors, string filePath = "")
        {
            errorExportFileCode = 1;
            errorStrArr = errors;
            errorNum = errors.Count;
            file = filePath;
            successNum = 0;
            msg = ImportEnum.ImportFailed;
        }
    }
}
