﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class MachineTypeList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }

        [ExcelColumn("父级类型")]
        [EmptyValidate("ParentTypeIsEmpty")]
        public string ParentType { get; set; }

        [ExcelColumn("子级类型")]
        public string ChildType { get; set; }

        [ExcelColumn("描述")]
        public string Description { get; set; }

        [ExcelColumn("包含设备数量")]
        [DonnetValidate]
        [DonnetCreate]
        public string Num { get; set; }
    }
}
