﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class ManualCollectionList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }

        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }

        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        [ExcelColumn("工序")]
        public string RouteName { get; set; }

        [ExcelColumn("位置")]
        public string Section { get; set; }

        [ExcelColumn("工单")]
        public string WorkOrder { get; set; }
        [ExcelColumn("二维码")]
        public string SN { get; set; }
        [ExcelColumn("偏差放行数量")]
        public string Quantity { get; set; }
        [ExcelColumn("原因")]
        public string Reason { get; set; }
        [ExcelColumn("结果1->OK;2->偏差放行;3->NG")]
        public string Result { get; set; }
        [ExcelColumn("检验人")]
        public string CheckUser { get; set; }
        [ExcelColumn("检验时间")]
        public string CheckTime { get; set; }
    }

    public class ManualCollectionDetailList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("项目")]
        public string Item { get; set; }
        [ExcelColumn("标准")]
        public string Standard { get; set; }
        [ExcelColumn("下限")]
        public string MinValue { get; set; }
        [ExcelColumn("上限")]
        public string MaxValue { get; set; }
        [ExcelColumn("标准极差")]
        public string Range { get; set; }
        [ExcelColumn("检验结果")]
        public string DetailResult { get; set; }
        [ExcelColumn("实际最小值")]
        public string LowerLimit { get; set; }
        [ExcelColumn("实际最大值")]
        public string UpperLimit { get; set; }
        [ExcelColumn("单值")]
        public string Value { get; set; }
        [ExcelColumn("实际极差")]
        public string ActualRange { get; set; }
        [ExcelColumn("描述")]
        public string Description { get; set; }
    }
}
