﻿using Siger.Middlelayer.Utility.ExcelImport;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    /// <summary>
    /// 产品物料清单-BOM
    /// </summary>
    public class ProductStructureBom : ImportBase
    {

        /// <summary>
        /// 导入 父级 产品/物料
        /// </summary>
        [ExcelColumn("产品Code/物料Pn")]
        public string ProductName { get; set; }

        /// <summary>
        /// 父级类型[1:产品 2：物料]
        /// </summary>
        [ExcelColumn("父级类型[1:产品 2：物料]")]
        public int ParentType { get; set; }
        /// <summary>
        /// 子级 物料PN
        /// </summary>
        [ExcelColumn("物料编号Pn")]
        public string MaterialPn { get; set; }
        [ExcelColumn("物料数量")]
        public int MaterialCount { get; set; }
    }

    public class ExportProductStructureBom : ImportBase
    {

        [ExcelColumn("ID")]
        public int Id { get; set; }
        /// <summary>
        /// 导入 父级 产品/物料
        /// </summary>
        [ExcelColumn("产品Code/物料Pn")]
        public string ProductName { get; set; }

        /// <summary>
        /// 父级类型[1:产品 2：物料]
        /// </summary>
        [ExcelColumn("父级类型[1:产品 2：物料]")]
        public int ParentType { get; set; }
        /// <summary>
        /// 父级ID
        /// </summary>
        //[ExcelColumn("父级ID")]
        //public int ParentId { get; set; }
        /// <summary>
        /// 子级 物料PN
        /// </summary>
        [ExcelColumn("物料编号Pn")]
        public string MaterialPn { get; set; }
        [ExcelColumn("物料数量")]
        public int MaterialCount { get; set; }
    }
}
