﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    /// <summary>
    /// 刀具供应商导入导出
    /// </summary>
    public class ToolSupplierList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }
       
        /// <summary>
        /// 刀具名称
        /// </summary>
        [ExcelColumn("刀具名称")]
        [EmptyValidate("ToolNameIsEmpty")]
        public string Name { get; set; }
        /// <summary>
        /// 刀具图纸号
        /// </summary>
        [ExcelColumn("刀具图纸号")]
        [EmptyValidate("ToolDrawCodeIsEmpty")]
        public string DrawingCode { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        [ExcelColumn("规格")]
        public string Spec { get; set; }

        /// <summary>
        /// 品牌
        /// </summary>
        [ExcelColumn("品牌")]
        public string Brand { get; set; }

        /// <summary>
        /// 材料
        /// </summary>
        [ExcelColumn("材料")]
        public string Material { get; set; }

        /// <summary>
        /// 硬度
        /// </summary>
        [ExcelColumn("硬度")]
        public string Hardness { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        [ExcelColumn("供应商")]
        public string Supplier { get; set; }

        /// <summary>
        /// 供应商编号
        /// </summary>
        [ExcelColumn("供应商代码")]
        public string SupplierCode { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        [ExcelColumn("单价")]
        public string UnitPrice { get; set; }
        
        /// <summary>
        /// 备注
        /// </summary>
        [ExcelColumn("备注")]
        public string Description { get; set; }
    }
}
