﻿using Siger.Middlelayer.Utility.ExcelImport;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class WorkingHourList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetExport]
        public int No { get; set; }

        [ExcelColumn("生产令号")]
        public string Abscissa { get; set; }

        [ExcelColumn("工单号")]
        public string OrderNumber { get; set; }

        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        [ExcelColumn("生产工时(分钟)")]
        public string WorkingHour { get; set; }

        [ExcelColumn("准终工时(分钟)")]
        public string Prepare { get; set; }

        [ExcelColumn("工时合计(分钟)")]
        public string Total { get; set; }
    }

    public class WorkingHourUserList : WorkingHourList
    {
        [ExcelColumn("姓名")]
        public string Name { get; set; }

        [ExcelColumn("工号")]
        public string WorkCode { get; set; }

        [ExcelColumn("班组")]
        public string WorkGroup { get; set; }
    }
}
