﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface IAutomationFixtureToolsRepository : IAccRepositoryBase<siger_automation_fixture_tools>
    {
        IPagedCollectionResult<ResponseFixtureTools> GetPagedList(int category, string code, string name, int state,
                int projectid, int page, int pagesize, string toexcel = "");

        IEnumerable<ResponseFixtureTools> GetDataList(int categoryid, int projectid);

        ResponseProductFixtureInfo GetProductFixtureLocation(int projectId, string guid);

        CommonImportResult ImportData(IEnumerable<FixtureToolsTemplate> list, int projectid, int userid);
    }
}
