﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface IAutomationLocationRepository : IAccRepositoryBase<siger_automation_location>
    {
        IPagedCollectionResult<ResponseAutomationLocation> GetPagedList(int wavehouseid, int locationid, int projectid, int page, int pagesize, string toexcel);


        siger_wms_storage_location GetLocation(int id, int projectid);

        IEnumerable<ResponseAutomationLocationList> GetDataList(int projectid);

        IEnumerable<siger_wms_storage_location> GetLocationList(int projectid);

        CommonImportResult ImportData(IEnumerable<AutomationLocationTemplate> list, int projectid, int userid);
    }
}
