﻿using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerRoutingInStation : IAccRepositoryBase<SigerTrRoutingInStation>
    {
        siger_project_product GetProductInfo(int projectid, string code);

        IEnumerable<SigerTrRoutingInStation> GetDataList(int fromline, int toline, int projectid);

        IEnumerable<RoutingInStation> GetRoutingInList(string productid, int line, int station, int projectid);

        CommonImportResult ImportRoutingInStation(IEnumerable<RoutingInStationTemplate> instations, int projectid);

        IEnumerable<RoutingInStation> GetRoutingStations(int line, string productid, int projectid);

        IPagedCollectionResult<ResponseRoutingData> GetRoutingData(RequestRoutingConfig conditions,int pid);

        CommonImportResult ImportRoutingData(IEnumerable<RoutingData> instations, int projectid);

        IPagedCollectionResult<ResponseRoutingInStation> GetRoutingInStationPage(int projectId, int line, int station, string productId, int page = 1, int pagesize = 10);
    }
}
