﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Linq.Expressions;
using System.Linq;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Extensions;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class ProductPlanDetailsRepository : AccRepositoryBase<siger_project_product_plan_detail>, IProductPlanDetails
    {
        private ApiAccDbContext _context;
        public ProductPlanDetailsRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseReportWorking> GetProductPlanData(int pid, int page, int pagesize, string startTime, string endTime, string ordernumber)
        {
            var query = from pd in _context.siger_project_product_plan_detail
                        join p in _context.siger_project_product_plan on pd.PlanId equals p.id
                        where pd.projectId.Equals(pid) && pd.status != (int)RowState.Invalid
                        select new ResponseReportWorking
                        {
                            OrderNumber = pd.OrderNumber,
                            StartTime = UnixTimeHelper.ConvertIntDateTime(pd.StartTime),
                            FinishTime = UnixTimeHelper.ConvertIntDateTime(pd.EndTime),
                            Count = pd.Quantity,
                            Status = pd.status,
                            ProductCode = p.product_code,
                            ProductName = p.product_name,
                            start = pd.StartTime,
                        };
            Expression<Func<ResponseReportWorking, bool>> funcOrder = f => true;
            if (!string.IsNullOrEmpty(ordernumber))
            {
                funcOrder = f => f.OrderNumber.Contains(ordernumber);
            }
            Expression<Func<ResponseReportWorking, bool>> funcTime = f => true;
            if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
            {
                var start = UnixTimeHelper.GetUnixByDate(startTime);
                var end = UnixTimeHelper.GetUnixByDate(endTime);
                funcTime = f => f.start >= start && f.start <= end;
            }
            var predicate = funcOrder.And(funcTime);
            var count = query.Count(predicate);
            var entity = query.Where(predicate).Skip((page - 1) * pagesize).Take(pagesize).ToList();
            return new PagedCollectionResult<ResponseReportWorking>(entity, count);
        }

        /// <summary>
        /// 获取工单工艺路径
        /// </summary>
        /// <param name="wo"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public ReposeProductRoute GetProductRoute(string wo, int projectId)
        {
            var query = from d in _context.siger_project_product_plan_detail
                        join s in _context.siger_project_produce_schedule on d.id equals s.plandetail_id
                        join r in _context.siger_project_product_route on s.route_name equals r.name
                        where d.OrderNumber==wo && d.projectId==projectId && s.projectId== r.projectId 
                        select new ReposeProductRoute {
                             Wo=wo,
                             SectionId=s.sectionId,
                             RouteId=r.id,
                             RouteName=r.name
                        };
            return query.FirstOrDefault();
        }
    }
}
