﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using System.Linq;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrBasketReportTTLRepository : AccRepositoryBase<siger_tr_basket_report_ttl>, ISigerTrBasketReportTTL
    {
        private ApiAccDbContext accDbContext;
        public SigerTrBasketReportTTLRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }
        /// <summary>
        /// 报工汇总
        /// </summary>
        /// <param name="order"></param>
        /// <param name="orderQty"></param>
        /// <param name="wo"></param>
        /// <param name="prodcutbh"></param>
        /// <param name="productanme"></param>
        /// <param name="producttype"></param>
        /// <param name="station"></param>
        /// <param name="position"></param>
        /// <param name="okCount"></param>
        /// <param name="nokCount"></param>
        /// <param name="nokCount2"></param>
        /// <param name="projectid"></param>
        public void CalculateReportTotal(string order, int orderQty, string wo, string prodcutbh, string productanme, string producttype, int station, int position, int okCount, int nokCount, int nokCount2,int projectid)
        {
            IFormatProvider ifp = new CultureInfo("zh-CN", true);
            var _busidateFormat = DateTime.Now.ToString("yyyyMMdd");
            var busidate = DateTime.ParseExact(_busidateFormat, "yyyyMMdd", ifp);

            GregorianCalendar gc = new System.Globalization.GregorianCalendar();
            int weekOfyear = gc.GetWeekOfYear(DateTime.Now, System.Globalization.CalendarWeekRule.FirstDay, DayOfWeek.Monday);
            var monthOfyear = busidate.Month;

            var reportTotal = accDbContext.siger_tr_basket_report_ttl.FirstOrDefault(f => f.projectId == projectid && f.BusiDate == busidate && f.Week == weekOfyear && f.Month == monthOfyear && f.OrderNo == order && f.WO == wo && f.Position == position);

            if (reportTotal == null)
            {
                accDbContext.siger_tr_basket_report_ttl.Add(new siger_tr_basket_report_ttl
                {
                    BusiDate = busidate,
                    Week = weekOfyear,
                    Month = monthOfyear,
                    OrderNo = order,
                    OrderQty = orderQty,
                    WO = wo,
                    ProductBh = prodcutbh,
                    ProductName = productanme,
                    ProductType = producttype,
                    Station = station,
                    Position = position,
                    projectId = projectid,
                    OkCount = okCount,
                    NgCount = nokCount,
                    NgCount2 = nokCount2,

                    status = 1
                });
            }
            else
            {
                reportTotal.OkCount += okCount;
                reportTotal.NgCount += nokCount;
                reportTotal.NgCount2 += nokCount2;
                accDbContext.siger_tr_basket_report_ttl.Update(reportTotal);
            }
        }

    }
}
