﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrReworkSnRepository : AccRepositoryBase<SigerTrReworkSnList>, ISigerTrReworkSnRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerTrReworkSnRepository(ApiAccDbContext apiAccDbContext) : base(apiAccDbContext)
        {
            accDbContext = apiAccDbContext;
        }

        public IPagedCollectionResult<ReworkSnInfo> GetReworkSnList(int projectId,string number, int page, int pagesize)
        {
            var query = from s in accDbContext.siger_tr_rework_sn_list
                        join r in accDbContext.siger_project_level_section on Convert.ToInt32(s.Line) equals r.id
                        join t in accDbContext.siger_project_level_section on Convert.ToInt32(s.ToStation) equals t.id
                        join u in accDbContext.siger_project_level_section on Convert.ToInt32(s.FromStation) equals u.id
                        where s.projectId==projectId && s.SN == number
                        select new ReworkSnInfo
                        {
                            ID = s.id,
                            WO = s.WO,
                            SN = s.SN,
                            Line = r.title,
                            FromStation = u.title,
                            FromStatus = s.FromStatus,
                            ToStation = t.title,
                            ToStatus = s.ToStatus,
                            Reason = s.Reason
                        };
            var totalCount = query.Count();
            var entities = query.OrderByDescending(q => q.ID).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ReworkSnInfo>(entities, totalCount);

        }

        public IPagedCollectionResult<ReworkSnInfo> GetReworkSnList(int projectId,DateTime beginDate, DateTime EndDate, int page, int pagesize, string number = "")
        {
            var query = from s in accDbContext.siger_tr_rework_sn_list
                        join r in accDbContext.siger_project_level_section on Convert.ToInt32(s.Line) equals r.id
                        join t in accDbContext.siger_project_level_section on Convert.ToInt32(s.ToStation) equals t.id
                        join u in accDbContext.siger_project_level_section on Convert.ToInt32(s.FromStation) equals u.id
                        where s.projectId==projectId && s.TransDateTime >= beginDate && s.TransDateTime <= EndDate
                        select new ReworkSnInfo
                        {
                            ID = s.id,
                            WO = s.WO,
                            SN = s.SN,
                            Line = r.title,
                            FromStation = u.title,
                            FromStatus = s.FromStatus,
                            ToStation = t.title,
                            ToStatus = s.ToStatus,
                            Reason = s.Reason
                        };
            Expression<Func<ReworkSnInfo, bool>> funNumber = f => true;
            if (!string.IsNullOrEmpty(number))
            {
                funNumber = f => f.SN.Contains(number);
            }
            var predicate = funNumber;
            var totalCount = query.Where(predicate).Count();
            var entities = query.Where(predicate).OrderByDescending(q => q.ID).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ReworkSnInfo>(entities, totalCount);
        }

    }
}
