﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerWoBookingItemRepository : AccRepositoryBase<SigerTrWOBookingItem>, ISigerWOBookingItem
    {
        private ApiAccDbContext accDbContext;
        public SigerWoBookingItemRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public CommonImportResult ImportWoBookingItem(IEnumerable<WOBookingItemTemplate> checkitems, int projectid, int userid)
        {
            var errors = new List<string>();
            var rowIndex = 1;
            var newList = new List<WOBookingItemTemplate>();
            foreach (var p in checkitems)
            {
                rowIndex++;

                var lines = accDbContext.siger_project_level_section.FirstOrDefault(t => t.title == p.line && t.status == (int)RowState.Valid && t.projectid == projectid);
                var stations = accDbContext.siger_project_level_section.FirstOrDefault(t => t.title == p.station && t.status == (int)RowState.Valid && t.projectid == projectid);
                var dict = accDbContext.siger_tr_dict.SingleOrDefault(t => t.cat == AccDictCost.item && t.status == (int)RowState.Valid && t.projectId == projectid && t.dval == p.item);

                if (lines != null && stations != null && dict != null)
                {
                    var model = accDbContext.siger_tr_wo_booking_item.FirstOrDefault(t => t.Line == lines.id && t.Station == stations.id
                        && t.Item == dict.dkey && t.projectId == projectid && t.status == (int)RowState.Valid);
                    var repeats = checkitems.Where(t => t.line == p.line && t.station == p.station && t.item == p.item);
                    if (model != null || repeats.Count() > 1)
                    {
                        errors.Add($"{rowIndex},{(int)RequestEnum.BookItemAddOrUpdateError}");
                    }
                }
                if (lines == null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.LineError}");
                }
                if(stations == null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.StationError}");
                }
                if (dict == null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.ItemNameNotExsitInDict}");
                }

                var seqs = newList.Count(t => t.line == p.line && t.station == p.station);
                p.seq = seqs > 0 ? seqs + 1 : 1;
                newList.Add(p);
            }

            if (errors.Any())
            {
                return new CommonImportResult(0, string.Join(";", errors));
            }

            var entities = new List<SigerTrWOBookingItem>();
            foreach (var p in newList)
            {
                var lines = accDbContext.siger_project_level_section.FirstOrDefault(t => t.title == p.line && t.status == (int)RowState.Valid && t.projectid == projectid);
                var stations = accDbContext.siger_project_level_section.FirstOrDefault(t => t.title == p.station && t.status == (int)RowState.Valid && t.projectid == projectid);
                var seqs = accDbContext.siger_tr_wo_booking_item.Count(t => t.projectId == projectid && t.Line == lines.id && t.Station == stations.id && t.status == (int)RowState.Valid);
                var dict = accDbContext.siger_tr_dict.SingleOrDefault(t => t.cat == AccDictCost.item && t.status == (int)RowState.Valid && t.projectId == projectid && t.dval == p.item);
                seqs = seqs > 0 ? seqs + p.seq : p.seq;
                var psEntity = new SigerTrWOBookingItem
                {
                    projectId = projectid,
                    Line = lines.id,
                    Station = stations.id,
                    Seq = seqs,
                    Item = dict.dkey ?? "",
                    Descr = p.descr ?? "",
                    UID = userid.ToString(),
                    TransDateTime = DateTime.Now
                };
                entities.Add(psEntity);
            }
            try
            {
                accDbContext.siger_tr_wo_booking_item.AddRange(entities);
                accDbContext.SaveChanges();
                return new CommonImportResult(1, "1");
            }
            catch
            {
                throw;
            }
        }
    }
}
