﻿using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrPackBoxSNListRepository : AccRepositoryBase<SigerTrPackBoxSNList>, ISigerTrPackBoxSNListRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerTrPackBoxSNListRepository(ApiAccDbContext apiAccDbContext) : base(apiAccDbContext)
        {
            accDbContext = apiAccDbContext;
        }

        public SigerTrPackBoxSNList GetDataBySN(string Sn, int ProjectId)
        {
            return accDbContext.siger_tr_pack_box_sn_list.Where(f => f.SN == Sn && f.projectId == ProjectId && f.status != (int)RowState.Invalid)
                .OrderByDescending(o => o.id).FirstOrDefault();
        }

        public ResponseGetSnListAndFullQty GetSnListByBoxId(string boxId, int pid)
        {
            var response = new ResponseGetSnListAndFullQty();

            if (string.IsNullOrWhiteSpace(boxId))
            {
                response.OperateEnum = (int)AccEnum.BoxIdIsNull;
                return response;
            }

            var box = accDbContext.siger_tr_pack_box_list.FirstOrDefault(q => q.BoxID.Equals(boxId) && q.projectId == pid && q.status != (int)RowState.Invalid);
            if (box == null)
            {
                response.OperateEnum = (int)AccEnum.Packing_Box_Null;
                return response;
            }

            return new ResponseGetSnListAndFullQty
            {
                FullQty = box.FullQty,
                SnList = accDbContext.siger_tr_pack_box_sn_list.Where(q =>
                    q.DeleteFlag == false && q.BoxID == boxId && q.projectId == pid &&
                    q.status != (int)RowState.Invalid).Select(m => m.SN).ToList(),
                TempBoxId = boxId,
                OperateEnum = (int)CommonEnum.Succefull
            };
        }
    }
}
