﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class TrParameterConfigRepository : AccRepositoryBase<SigerTrParameterConfig>, ITrParameterConfigRepository
    {
        private readonly ApiAccDbContext _context;
        public TrParameterConfigRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseParameterConfig> GetPagedConfigList(int section_id, int page, int pagesize,
            int projectId, int toexcel)
        {
            var query = from q in _context.siger_tr_parameter_config
                join u in _context.siger_project_user on q.creator_mid equals u.mid
                where q.projectId == projectId && q.status == (int) RowState.Valid
                select new ResponseParameterConfig
                {
                    section_id = q.section_id,
                    name = q.name,
                    attribute = q.attribute,
                    create_time = q.create_time.ToString(ParameterConstant.DateTimeFormat),
                    user_name = u.name,
                    id = q.id,
                };

            Expression<Func<ResponseParameterConfig, bool>> sectionExpression = f => true;
            if (section_id != 0)
            {
                var sectionids = GetSonLevelSectionIds(section_id, projectId);
                sectionExpression = f => sectionids.Contains(f.section_id);
            }

            if (toexcel == 0)
            {
                var total = query.Count(sectionExpression);
                var data = query.Where(sectionExpression).Skip((page - 1) * pagesize).Take(pagesize).ToList();
                return new PagedCollectionResult<ResponseParameterConfig>(data, total);
            }
            else
            {
                var data = query.Where(sectionExpression).Take(pagesize).ToList();
                return new PagedCollectionResult<ResponseParameterConfig>(data, 0);
            }
        }

        public CommonImportResult ImportConfig(IEnumerable<TrParameterConfigTemplate> instations, int projectid, int userId)
        {
            var errors = new List<string>();
            var rowIndex = 1;
            foreach (var p in instations)
            {
                rowIndex++;
                var stationmodel = _context.siger_project_level_section.FirstOrDefault(t => t.title == p.SectionName && t.projectid == projectid && t.status == (int)RowState.Valid);
                if (stationmodel == null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.StationError}");
                }
            }
            if (errors.Any())
            {
                return new CommonImportResult(0, string.Join(";", errors));
            }

            var list = new List<SigerTrParameterConfig>();
            foreach (var item in instations)
            {
                var stationmodel = _context.siger_project_level_section.First(t => t.title == item.SectionName && t.projectid == projectid && t.status == (int)RowState.Valid);
                var entity = new SigerTrParameterConfig
                {
                    section_id = stationmodel.id,
                    name = item.Name,
                    attribute = item.Attribute,
                    create_time = DateTime.Now,
                    creator_mid = userId,
                    projectId = projectid,
                    status = (int)RowState.Valid
                };
                list.Add(entity);
            }
            try
            {
                _context.siger_tr_parameter_config.AddRange(list);
                _context.SaveChanges();
                return new CommonImportResult(1, "1");
            }
            catch
            {
                throw;
            }
        }
    }
}
