﻿using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Response
{
    public class ResponseCategory
    {
        public int id { get; set; }
        public string pid { get; set; }
        public string name { get; set; }
        public string image { get; set; }
        public int ctype { get; set; }
        public string posturl { get; set; }
        public string json { get; set; }
        public string header { get; set; }
        public string open { get; set; }
        public int sort { get; set; }
        public string create_name { get; set; }
        public string create_by { get; set; }
    }

    public class CategoryTree
    {
        public int id { get; set; }

        public string name { get; set; }

        public string pid { get; set; }

        public bool open { get; set; }

        public string image { get; set; }
        public int ctype { get; set; }
        public string posturl { get; set; }
        public string json { get; set; }
        public string header { get; set; }
        public int sort { get; set; }

        public List<CategoryTree> children { get; set; }

        public void AddChildren(CategoryTree node)
        {
            if (children == null)
            {
                children = new List<CategoryTree>();
            }
            children.Add(node);
        }
    }

    public class ResponseCategoryChildren
    {
        public IEnumerable<CategoryTree> children { get; set; }

        public ResponseCategoryChildren(IEnumerable<CategoryTree> tree)
        {
            children = tree;
        }
    }
}
