﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.CncRepository.Repositories.Interface
{
    public interface IProductPlanDetailRepository : ICncRepositoryBase<siger_project_product_plan_detail>
    {
        IPagedCollectionResult<ResponseGetOrders> GetPagedWorkOrderList(string productName, string code, string orderNumber, int status,
            string startTime, string endTime, int projectId, int page, int pagesize);
        IPagedCollectionResult<ResponseGetOrders> GetPagedWorkOrderListData(string productName, string code, string orderNumber, int status,
            string startTime, string endTime, int projectId, int page, int pagesize);
        IEnumerable<ResponseWorkOrderList> GetWorkOrderData(int id, int projectId);

        IEnumerable<ResponseIdTitle> GetSectionTitles(IEnumerable<int> sectionIds, int projectId);

        /// <summary>
        /// 生产计划执行
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="productId"></param>
        /// <param name="projectId"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="toexcel"></param>
        /// <returns></returns>
        IPagedCollectionResult<ResponseGetOrders> GetPlanExecuteList(int startTime, int endTime,
            int productId, int projectId, int page, int pagesize, int toexcel);

        /// <summary>
        /// 工单甘特图
        /// </summary>
        /// <param name="productName"></param>
        /// <param name="draw_number"></param>
        /// <param name="code"></param>
        /// <param name="status"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IEnumerable<ResponseWorkOrderGante> GetWorkOrderGante(string productName, string draw_number, string code,
            int status, int startTime, int endTime, int projectId);

        /// <summary>
        /// 生产管理APP获取工单列表
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="planIds"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IEnumerable<ResponseGetOrders> GetSignPlans(int startTime, int endTime, IEnumerable<int> planIds, int projectId);

        IEnumerable<ResponseGetOrders> GetWorkOrderProgress(string productName, string orderNumber,
            DateTime startTime, DateTime endTime, int projectId);

        /// <summary>
        /// 获取排产工令单信息 （电子票据）
        /// </summary>
        /// <param name="wo"></param>
        /// <param name="projeceId"></param>
        /// <returns></returns>
        ScheduleWoInfo GetWoSchedule(string wo, int projeceId);

        IEnumerable<ResponsePlanReportDetails> GetPlanReports(int projectId, int planId,int planDtsId);

        string GetDrawUrl(int productId, int projectId);
    }
}
