﻿using System.Collections.Generic;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.CncRepository.Repositories.Interface
{
    public interface IProductionBeatSetRepository : ICncRepositoryBase<siger_project_beat_set>
    {
        IPagedCollectionResult<ResponseBeatSet> GetPagedList(int sectionid, string product_name_text,
            string drawing_number, int projectId, int page,
            int pagesize);

        IEnumerable<ResponseGetBeatInfo> GetBeatInfos(int productId, IEnumerable<int> sectionIds, int projectId);

        CommonImportResult ImportBeats(IEnumerable<BeatSetEntity> beatSetEntities, int projectid);

        IEnumerable<ProductReport> GetProductReport(long startTime, long endTime, IEnumerable<int> machineIds,int projectId);

        IEnumerable<ProductReport> GetSignProductReport(long startTime, long endTime, IEnumerable<int> machineIds, int projectId);
    }
}
