﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Common;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class ProjectProductPlanChangeRecordReponsitory : CncRepositoryBase<siger_project_product_plan_change_record>, IProjectProductPlanChangeRecordReponsitory
    {
        private readonly ApiCncDbContext _context;
        public ProjectProductPlanChangeRecordReponsitory(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        /// <summary>
        /// 计划变更记录查询
        /// </summary>
        /// <param name="product_name">产品名称</param>
        /// <param name="ordernumber">订单号</param>
        /// <param name="startTime">变更时间开始</param>
        /// <param name="endTime">变更时间结束</param>
        /// <param name="audit_state">变更状态</param>
        /// <param name="projectId">项目id</param>
        /// <param name="page">第几页</param>
        /// <param name="pagesize">每页条数</param>
        /// <returns></returns>
        public IPagedCollectionResult<ResponseProductPlanChangeRecord> GetPagedProductPlan(string product_name, string ordernumber, int startTime, int endTime,
            int audit_state, int projectId, int page, int pagesize)
        {
            var entity = from q in _context.siger_project_product_plan_change_record
                         join p in _context.siger_project_product_plan on q.plan_id equals p.id
                         where q.projectid==projectId && q.status==(int)RowState.Valid
                         select new ResponseProductPlanChangeRecord
                         {
                             id=q.id,
                             ordernumber=q.ordernumber,
                             code=q.code,
                             product_name = q.product_name,
                             product_code = q.product_code,
                             draw_number = q.draw_number,
                             workordertype = q.workordertype,
                             quantity = q.quantity,
                             install_count = q.install_count,
                             delivery_time = UnixTimeHelper.ConvertIntDate(q.delivery_time),
                             change_project = EnumHelper.GetEnumDesc(q.change_project),
                             change_before = q.change_before,
                             change_after = q.change_after,
                             audit_state = q.audit_state,
                             change_time = q.change_time,
                         };
            Expression<Func<ResponseProductPlanChangeRecord, bool>> productNameExpression = q => true;
            if (!string.IsNullOrEmpty(product_name))
            {
                productNameExpression = q => q.product_name.Contains(product_name);
            }
            Expression<Func<ResponseProductPlanChangeRecord, bool>> orderNumberExpression = q => true;
            if (!string.IsNullOrEmpty(ordernumber))
            {
                orderNumberExpression = q => (q.ordernumber.Contains(ordernumber));
            }
            Expression<Func<ResponseProductPlanChangeRecord, bool>> startTimeExpression = q => true;
            if (startTime != 0 && endTime != 0)
            {
                startTimeExpression = q => q.change_time >= startTime && 
                q.change_time <= endTime;
            }
            Expression<Func<ResponseProductPlanChangeRecord, bool>> auditStatexpression = q => true;
            if (audit_state!=0)
            {
                auditStatexpression = q => (q.audit_state == audit_state);
            }
            var predicate = productNameExpression.And(orderNumberExpression).And(startTimeExpression).And(startTimeExpression).And(auditStatexpression);

            var totalCount = entity.Count(predicate);
            var entities = entity.Where(predicate).OrderByDescending(f=>f.change_time)
                .Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ResponseProductPlanChangeRecord>(entities, totalCount);
        }
    }
}
