﻿using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Linq;
using Siger.Middlelayer.Repository.Extensions;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.Extensions;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    /// <summary>
    /// 计划外派工实现类
    /// </summary>
    internal class ProjectProductPlanOutDispatchReponsitory : CncRepositoryBase<siger_project_product_plan_out_dispatch>, IProjectProductPlanOutDispatchReponsitory
    {
        private readonly ApiCncDbContext _context;
        public ProjectProductPlanOutDispatchReponsitory(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        /// <summary>
        /// 计划外派工查询
        /// </summary>
        /// <param name="tasknumber">任务编号</param>
        /// <param name="executive">执行人员</param>
        /// <param name="starttime">派工日期开始</param>
        /// <param name="endtime">派工日期结束</param>
        /// <param name="taskname">任务名称</param>
        /// <param name="projectid">项目id</param>
        /// <param name="page">第几页</param>
        /// <param name="pagesize">每页条数</param>
        /// <returns></returns>
        public IPagedCollectionResult<ResponseProductPlanOutDispatch> GetPagedProductPlanOutDispatch(string tasknumber, string executive, int starttime,
            int endtime, string taskname, int projectid, int page, int pagesize)
        {
            var entity = from q in _context.siger_project_product_plan_out_dispatch
                         //join sg in _context.siger_project_working_group on q.groupid equals sg.id
                         join su in _context.siger_project_user on q.planexecutor equals su.mid
                         join au in _context.siger_project_user on q.actualexecutor equals au.mid into atemp
                         from au in atemp.DefaultIfEmpty()
                         where q.projectid == projectid 
                         select new ResponseProductPlanOutDispatch
                         {
                             id = q.id,
                             createuser = q.createuser,
                             createtime= UnixTimeHelper.ConvertIntDateTime(q.createtime),
                             createtimeInt= q.createtime,
                             tasknumber =q.tasknumber,
                             taskname=q.taskname,
                             taskcontent=q.taskcontent,
                             //groupname = sg.name,
                             planexecutor = su.name,
                             expectedtime = q.expectedtime,
                             actualexecutor =au!=null? au.name:"",
                             actualtime = au != null ? q.actualtime.ToStr():"",
                             reportingtime = UnixTimeHelper.ConvertIntDateTime(q.reportingtime),
                             state = q.state
                         };
            Expression<Func<ResponseProductPlanOutDispatch, bool>> tasknumberExpression = q => true;
            if (!string.IsNullOrEmpty(tasknumber))
            {
                tasknumberExpression = q => (q.tasknumber.Contains(tasknumber));
            }
            Expression<Func<ResponseProductPlanOutDispatch, bool>> executiveExpression = q => true;
            if (!string.IsNullOrEmpty(executive))
            {
                executiveExpression = q => q.actualexecutor.Contains(executive);
            }           
            Expression<Func<ResponseProductPlanOutDispatch, bool>> tasknameExpression = q => true;
            if (!string.IsNullOrWhiteSpace(taskname))
            {
                tasknameExpression = q => q.taskname.Contains(taskname);
            }
            Expression<Func<ResponseProductPlanOutDispatch, bool>> startTimeExpression = q => true;
            if (starttime != 0 && endtime != 0)
            {
                startTimeExpression = q => q.createtimeInt >= starttime && q.createtimeInt <= endtime;
            }
            var predicate = tasknumberExpression.And(executiveExpression).And(tasknameExpression).And(startTimeExpression);
            var totalCount = entity.Count(predicate);
            var entities = entity.Where(predicate).OrderByDescending(q => q.createtime)
                .Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ResponseProductPlanOutDispatch>(entities, totalCount);
        }
        
        /// <summary>
        /// 获取外派工数量
        /// </summary>
        /// <param name="projectid">项目id</param>
        /// <returns></returns>
        public GetDataTasknumber GetData(int projectid) 
        {
            var entity = from q in _context.siger_project_product_plan_out_dispatch.
                         Where(q => q.projectid == projectid)
                         select new GetTasknumber 
                         {
                             tasknumber=q.tasknumber
                         };
            var entities = entity.Where(f=>f.tasknumber.Contains(DateTime.Now.ToString("yyyyMMdd"))).ToList();
            var data = new GetDataTasknumber()
            {
                count = entities.Count(),
                data = entities,
            };
            return data;
        }

        /// <summary>
        /// 报工弹框数据
        /// </summary>
        /// <param name="id">数据id</param>
        /// <param name="projectid">项目id</param> 
        /// <returns></returns>
        public ResponseProductPlanOutDispatch GetReport(int id,int projectid)
        {
            var entity = from q in _context.siger_project_product_plan_out_dispatch
                         join sg in _context.siger_project_working_group on q.groupid equals sg.id
                         join su in _context.siger_project_user on q.planexecutor equals su.mid
                         join au in _context.siger_project_user on q.actualexecutor equals au.mid into atemp
                         from au in atemp.DefaultIfEmpty()
                         where q.id == id && q.projectid==projectid
                         select new ResponseProductPlanOutDispatch
                         {
                             id = q.id,
                             createuser = q.createuser,
                             createtime = UnixTimeHelper.ConvertIntDateTime(q.createtime),
                             createtimeInt = q.createtime,
                             tasknumber = q.tasknumber,
                             taskname = q.taskname,
                             taskcontent = q.taskcontent,
                             groupname = sg.name,
                             planexecutor = su.name,
                             expectedtime = q.expectedtime,
                             actualexecutor = au.name,
                             actualtime = q.actualtime.ToStr(),
                             reportingtime = UnixTimeHelper.ConvertIntDateTime(q.reportingtime),
                             state = q.state
                         };
            return entity.FirstOrDefault();
        }
    }
}
