﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.DncRepository.Entities;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.DncRepository
{
    public class ApiDncDbContext : DbContext
    {
        public ApiDncDbContext()
        {

        }
        public ApiDncDbContext(DbContextOptions<ApiDncDbContext> options) : base(options)
        {
        }
        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_project_dnc_user_power> siger_project_dnc_user_power { get; set; }
        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<siger_user> siger_user { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }
        public DbSet<siger_project_section> siger_project_section { get; set; }
        public DbSet<siger_project_dnc_program> siger_project_dnc_program { get; set; }
        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<siger_project_dnc> siger_project_dnc { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_dnc_job_program> siger_project_dnc_job_program { get; set; }
        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }
    }
}
