﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DncRepository.Entities;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.DncRepository.Repositories
{
    internal abstract class DncRepositoryBase<TEntity> : RepositoryBase<TEntity> where TEntity : DncEntityBase
    {
        private readonly ApiDncDbContext _dbContext;
        protected DncRepositoryBase(ApiDncDbContext context) : base(context)
        {
            _dbContext = context;
        }
        public IEnumerable<int> GetSonLevelSectionIds(int sectionId, int projectid)
        {
            var list = new List<int> { sectionId };

            var query = GetSonLevelSections(sectionId, projectid);
            foreach (var section in query.ToList())
            {
                list.Add(section.id);
            }

            return list;
        }

        private IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, int projectid)
        {
            var query = from c in _dbContext.siger_project_level_section
                        where c.parentid == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevelSections(t.id, projectid)));
        }

        public IEnumerable<ResponseGetSectionMachine> GetLevels(int levelid, int projectId)
        {
            var data= _dbContext.siger_project_level_section.Where(f => f.levelid == levelid && f.status == (int)RowState.Valid && f.projectid == projectId)
                                                            .Select(f=> new ResponseGetSectionMachine
                                                            {
                                                                id = f.id,
                                                                title = f.title
                                                            });
            return data;
        }
    }
}
