﻿using System;
using System.Collections;
using System.Collections.Generic;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DncRepository.Entities;
using Siger.Middlelayer.DncRepository.Response;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.DncRepository.Repositories.Interface
{
    public interface ISigerProjectDncProgramRepository : IDncRepositoryBase<siger_project_dnc_program>
    {
        ResponseProgramInfo GetProgramInfo(int projectId, int programid);
        IEnumerable<ResponseProgramInfo> GetProgramInfoById(int projectId, int programid);
        ResponseProgramInfo GetProgramInfos(int projectId, int programid);
        void EditProgram(int programid, string file_url, string file_name, int file_size, int productid, int checkmid, string createremark, string programcode);
        void CheckProgramPost(int projectId, int userId, int programid, string check_remark, int num, string programcode);
        ResponseGetSectionMachine GetSectionMachine(int projectId, int sectionid);

        IPagedCollectionResult<ResponsePguploadLists> GetPguploadlists(ResponseGetSectionMachine machine, DateTime starttime, DateTime endtime, int page, int pagesize);
        IList<ResponseAllPrograms> GetPrograms(int projectId,string product,int checkstatus);
        IPagedCollectionResult<ResponseAllPrograms> SearchProgramEx(int projectId, string product, int checkstatus, int page, int pagesize);
        
        siger_project_dnc UploadProgram(int projectId,int userId, int machineid, int programid, ResponseProgramInfo programinfo, out string param);
        void AddDnc(siger_project_dnc data);
        IEnumerable<ResponseAllPrograms> GetCheckProgram(int projectId, List<string> pros);
        ResponseAllPrograms GetProgramCheckedInfo(int projectId, string programCode);
        IEnumerable<ResponseAllPrograms> GetCheckProgramDeleteList(List<string> pros);
        IEnumerable<ResponseAllPrograms> GetCheckProgramDeleteList(List<string> pros,int machineid);

        IList<ResponseAllPrograms> GetAllProgarm(int projectId, string keyword, int checkstatus, int page, int pageSize,out int totalCount);
        string GetRegion(int sectionid, int projectId);
        int GetPgUploadCount(List<int> machineIdList, DateTime st, DateTime et);
        List<ResponsegetPgUploadCount> GetPgUploadCountBymid(List<int> machineIdList, string type, DateTime starttime, DateTime endtime,int projectid);
        List<ResponsegetPgUploadCount> GetPgUploadCountByProduct(List<int> machineIdList, DateTime starttime, DateTime endtime, int projectId);
        List<ResponsePgHistoryCountByMid> GetPgHistoryCountBymid(int CID, int PID, List<int> machineIdList, string type3, DateTime starttime, DateTime endtime, int projectId);
        List<ResponsePgHistoryCountByMid> GetPgHistoryCountByProduct(int CID, int PID, List<int> machineIdList, DateTime starttime, DateTime endtime, int projectId);
        MachineAttributeType GetMachineAttribute(int machineid);

        IEnumerable<siger_project_dnc_program> getAllCheckProgramDeleteList(List<string> pros, int projectid);

        IEnumerable<siger_project_dnc> GetDncs(int machineid, int projectid);

        siger_project_dnc UploadProgramZip(int projectId, int userId, int machineid, int programid, ResponseProgramInfo programinfo);
        IEnumerable<ResponseProgramInfo> GetListByGuidCode(string guidcode,int projectid,string drawcode);

    }
}
