﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Repositories.Interface;
using Siger.Middlelayer.IMSRepository.Response;

namespace Siger.Middlelayer.IMSRepository.Repositories
{
    internal class ToolLifeToolScrapRepository : IMSRepositoryBase<siger_project_ims_tool_scrap>, IToolLifeToolScrapRepository
    {
        private readonly ApiIMSDbContext _context;
        public ToolLifeToolScrapRepository(ApiIMSDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseGetToolScrap> GetPagedList(int materialid, int status, int starttime, int endtime, 
            int page, int pagesize, int projectId, int toexcel)
        {
            var querylist = from q in _context.siger_project_ims_tool_scrap
                join t in _context.siger_project_ims_tool on q.material_id equals t.material_id
                join m in _context.siger_tr_materials on q.material_id equals m.id
                join u in _context.siger_project_user on q.review_mid equals u.mid into uu
                from u in uu.DefaultIfEmpty()
                where q.status != (int) RowState.Invalid && q.project_id == projectId &&
                      t.status == (int) RowState.Valid && t.project_id == projectId
                select new ResponseGetToolScrap
                {
                    id = q.id,
                    serial_number = q.stock_number,
                    material_name = m.name ?? "",
                    status = q.status,
                    part_no = q.part_no,
                    ctime = q.create_time,
                    reason = q.reason,
                    review_remark = q.review_remark,
                    review_time = UnixTimeHelper.ConvertIntDateTime(q.review_time),
                    reviewer = u.name ?? "",
                    material_id = q.material_id
                };
            Expression<Func<ResponseGetToolScrap, bool>> statusExpression = q => true;
            if (status != 0)
            {
                statusExpression = q => q.status == status;
            }
            Expression<Func<ResponseGetToolScrap, bool>> timeExpression = q => true;
            if (starttime > 0 && endtime>0)
            {
                timeExpression = q => (q.ctime <= endtime && q.ctime >= starttime);
            }
            Expression<Func<ResponseGetToolScrap, bool>> partNoExpression = q => true;
            if (materialid>0)
            {
                partNoExpression = q => q.material_id == materialid;
            }

            var predicate = statusExpression.And(timeExpression).And(partNoExpression);

            if (toexcel == 0)
            {
                var totalCount = querylist.Count(predicate);
                var entities = querylist.Where(predicate).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseGetToolScrap>(entities, totalCount);
            }
            else
            {
                var entities = querylist.Where(predicate).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseGetToolScrap>(entities, 0);
            }
        }
    }
}
