﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.KpiRespository.Respose;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using Siger.Middlelayer.Share.ModuleEnum;
namespace Siger.Middlelayer.KpiRespository.Repositories.Interface
{
    public interface ISigerKpiTasklist : ISigerKpiBase<SigerProjectKpiTasklist>
    {
        IPagedCollectionResult<ResponseTasklist> GetTaskItemPagedList(int section, string item, DateTime begin, DateTime end, int status, int excption, int projectid, int page, int pagesize, int taskResult = 0);

        IPagedCollectionResult<ResponseTasklist> GetTaskItemMoblie(int section, string item, DateTime begin, DateTime end, int status, int excption, int projectid, int page, int pagesize);
        CommonImportResult ImportKpiTaskAct(IEnumerable<ImportKpiTaskAct> items, int projectId);
        KpiTaskResult GetState(double ActVal, double TargetVal, siger_project_kpi_item itemObj);
        IEnumerable<ResponseTasklist> GetTaskItem(int section, int item, DateTime begin, DateTime end, int projectid);
        IEnumerable<ResponseTasklist> GetTaskItemRepeat(int section, int item, DateTime begin, DateTime end, int projectid);

        double GetKpiTarget(int itemid, int projectId);

        double GetKpiValue(int itemid, int projectId, DateTime sdate, DateTime edate);

        double GetKpiComplaint(int itemid, int projectId, DateTime sdate, DateTime edate);

        double GetKpiSafeDay(int itemName, int projectId);

        List<SigerProjectKpiTasklist> GetKpiComplaints(int itemid, int projectId);

        IPagedCollectionResult<ResponseInputTasklist> GetInputTasklists(int section, int itemId, KpiCycleEnum kpiCycle, int projectId, DateTime begin, DateTime end, int page, int pagesize);

        IEnumerable<ResponseKpiActionInfo> GetActionResult(int projectId, List<int> taskIds);
    }
}
