﻿using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Siger.Middlelayer.KpiRespository.Respose;
using Siger.Middlelayer.Common;

namespace Siger.Middlelayer.KpiRespository.Repositories
{
    internal class KpiPlanReportLevleRepository : KpiRepositoryBase<siger_project_plan_report_level>, ISigerPlanReportLevel
    {
        private ApiKpiDbContext kpiDbContext;
        public KpiPlanReportLevleRepository(ApiKpiDbContext context) : base(context)
        {
            kpiDbContext = context;
        }

        public IEnumerable<ResponseUserGroup> GetUserGroupsBySettingCode(int projectId, string processCode)
        {
            var query = from l in kpiDbContext.siger_project_plan_report_level
                        join u in kpiDbContext.siger_project_usergroup on l.usergroup_id equals u.id
                        where l.project_id == projectId && l.process_code == processCode && l.status==(int)RowState.Valid
                        select new ResponseUserGroup
                        {
                            Level=l.level,
                            Id=u.id,
                            Name=u.title
                        };
            return query;
        }

    }
}
