﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.QmsRepository
{
    public class ApiQmsDbContext : DbContext
    {
        public ApiQmsDbContext()
        {

        }
        public ApiQmsDbContext(DbContextOptions<ApiQmsDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_qms_inspection_standard> siger_qms_inspection_standard { get; set; }

        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }

        public DbSet<SigerTrDict> siger_tr_dict { get; set; }

        public DbSet<siger_project_product> siger_project_product { get; set; }

        public DbSet<siger_project_user> siger_project_user { get; set; }

        public DbSet<siger_user> siger_user { get; set; }
        public DbSet<siger_qms_sensor_type> siger_qms_sensor_type { get; set; }
        public DbSet<siger_qms_sensor_parameter> siger_qms_sensor_parameter { get; set; }
        public DbSet<siger_qms_sensor_file> siger_qms_sensor_file { get; set; }
        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<siger_project_machine_extend> siger_project_machine_extend { get; set; }

        public DbSet<siger_project_level_section_machine> siger_project_level_section_machine { get; set; }
        public DbSet<siger_qms_sensor_detail> siger_qms_sensor_detail { get; set; }
        public DbSet<SigerProjectEmailConfig> siger_project_email_config { get; set; }

        public DbSet<siger_qms_inspection_unhealthy> siger_qms_inspection_unhealthy { get; set; }
        public DbSet<siger_qms_inspection_unhealthy_category> siger_qms_inspection_unhealthy_category { get; set; }
        public DbSet<siger_qms_abnormal_rule> siger_qms_abnormal_rule { get; set; }

        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }

        public DbSet<siger_qms_standard_parts> siger_qms_standard_parts { get; set; }

        public DbSet<siger_qms_standard_parts_sn> siger_qms_standard_parts_sn { get; set; }

        public DbSet<siger_tr_materials> siger_tr_materials { get; set; }
        public DbSet<siger_qms_rework_data> siger_qms_rework_data { get; set; }
        public DbSet<siger_qms_rework_setting> siger_qms_rework_setting { get; set; }

        public DbSet<siger_check_sn_trace_inspection> siger_check_sn_trace_inspection { get; set; }

        public DbSet<siger_check_sn_trace_material> siger_check_sn_trace_material { get; set; }

        public DbSet<siger_check_sn_trace_material_detail> siger_check_sn_trace_material_detail { get; set; }

        public DbSet<siger_wms_bussinese_contacts> siger_wms_bussinese_contacts { get; set; }

        public DbSet<siger_check_sn_trace_file> siger_check_sn_trace_file { get; set; }

        public DbSet<SigerTrRoutingEventNo> siger_tr_routing_eventno { get; set; }

        public DbSet<SigerTrRoutingOutStation> siger_tr_routing_outstation { get; set; }

        public DbSet<SigerTrRoutingInStation> siger_tr_routing_instation { get; set; }

        public DbSet<siger_check_sn_list> siger_check_sn_list { get; set; }

        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }

        public DbSet<siger_qms_port_setting> siger_qms_port_setting { get; set; }

        public DbSet<siger_qms_defaultinfo_config> siger_qms_defaultinfo_config { get; set; }

        public DbSet<siger_qms_parametermaintain_config> siger_qms_parametermaintain_config { get; set; }
        public DbSet<siger_qms_rework_reference> siger_qms_rework_reference { get; set; }

        public DbSet<siger_project_product_structure> siger_project_product_structure { get; set; }
        public DbSet<siger_qms_rework_postion_setting> siger_qms_rework_postion_setting { get; set; }
        public DbSet<siger_qms_rework_data_ttl> siger_qms_rework_data_ttl { get; set; }

        public DbSet<siger_qms_inspection_standard_material> siger_qms_inspection_standard_material { get; set; }

        public DbSet<siger_check_testroom> siger_check_testroom { get; set; }

        public DbSet<siger_qms_check_message> siger_qms_check_message { get; set; }
        public DbSet<siger_qms_barcodegun_set> siger_qms_barcodegun_set { get; set; }

        public DbSet<siger_qms_barcode_batch> siger_qms_barcode_batch { get; set; }

        public DbSet<siger_check_partindex> siger_check_partindex { get; set; }


        public DbSet<siger_qms_inspection_standard_category> siger_qms_inspection_standard_category { get; set; }

        public DbSet<siger_qms_inspection_standard_item> siger_qms_inspection_standard_item { get; set; }

        public DbSet<siger_qms_type_count_setting> siger_qms_type_count_setting { get; set; }
        public DbSet<siger_qms_sendtest_parameter> siger_qms_sendtest_parameter { get; set; }
        public DbSet<siger_check_sn_trace_detail> siger_check_sn_trace_detail { get; set; }
        public DbSet<siger_qms_check_paramter> siger_qms_check_paramter { get; set; }
        public DbSet<siger_qms_rework_type> siger_qms_rework_type { get; set; }
        public DbSet<siger_qms_cell> siger_qms_cell { get; set; }
        public DbSet<siger_qms_cell_station> siger_qms_cell_station { get; set; }
        public DbSet<siger_qms_cell_manufacturing> siger_qms_cell_manufacturing { get; set; }
        public DbSet<siger_qms_cell_cfg> siger_qms_cell_cfg { get; set; }


        public DbSet<siger_system_config> siger_system_config { get; set; }
        public DbSet<siger_qms_product_addition> siger_qms_product_addition { get; set; }
        public DbSet<siger_qms_product_warehousing> siger_qms_product_warehousing { get; set; }


        public DbSet<SigerProjectKpiTasklist> siger_project_kpi_tasklist { get; set; }
        public DbSet<siger_qms_rework_data_material> siger_qms_rework_data_material { get; set; }

        public DbSet<SigerProjectKpiItem> siger_project_kpi_item { get; set; }

        public DbSet<siger_andon_info> siger_andon_info { get; set; }

        public DbSet<siger_andon_info_detail> siger_andon_info_detail { get; set; }

        public DbSet<siger_andon_expection_type> siger_andon_expection_type { get; set; }

        public DbSet<siger_qms_inspection_standard_option> siger_qms_inspection_standard_option { get; set; }

        public DbSet<siger_tr_sn_trace> siger_tr_sn_trace { get; set; }

        public DbSet<siger_tr_sn_trace_detail> siger_tr_sn_trace_detail { get; set; }

    }
}
