﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System.Collections.Generic;
using System.Linq;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class PortSettingRepository : QMSRepositoryBase<siger_qms_port_setting>, IPortSettingRepository
    {
        private readonly ApiQmsDbContext _context;
        public PortSettingRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseGetPortSettings> GetPagedList(int projectId, int page, int pagesize)
        {
            var rowstate = (int)RowState.Valid;
            var query = _context.siger_qms_port_setting.Where(q => q.projectid == projectId && q.status == rowstate);
            var querylist = from q in query
                            join i in _context.siger_qms_inspection_standard on q.itemid equals i.id
                            orderby q.createtime descending
                            select new ResponseGetPortSettings
                            {
                                id = q.id,
                                port = q.port,
                                paritycheck = q.paritycheck,
                                baudrate = q.baudrate,
                                databit = q.databit,
                                stopbit = q.stopbit,
                                itemid = q.itemid,
                                itemname = i.item ?? "",
                                itemname_en = i.item_en
                            };
            
            var totalCount = querylist.Count();
            var entities = querylist.Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ResponseGetPortSettings>(entities, totalCount);
        }

        public IEnumerable<ResponseGetPortSettings> GetDataList(int projectId)
        {
            var rowstate = (int)RowState.Valid;
            var query = _context.siger_qms_port_setting.Where(q => q.projectid == projectId && q.status == rowstate);
            var querylist = from q in query
                            join i in _context.siger_qms_inspection_standard on q.itemid equals i.id
                            orderby q.createtime descending
                            select new ResponseGetPortSettings
                            {
                                id = q.id,
                                port = q.port,
                                paritycheck = q.paritycheck,
                                baudrate = q.baudrate,
                                databit = q.databit,
                                stopbit = q.stopbit,
                                itemid = q.itemid,
                                itemname = i.item ?? "",
                                itemname_en = i.item_en
                            };

            return querylist;
        }
    }
}
