﻿using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.QmsRepository.Request
{
    public class RequestIncomingMaterial
    {
        public int sectionid { get; set; }

        public int materialid { get; set; }

        public string supplierid { get; set; }

        public string partno { get; set; }

        public int totalquantity { get; set; }

        public int randomchecknumber { get; set; }

        public string result { get; set; }

        public string batchnumber { get; set; }

        public List<IncomingMaterialDataDetail> details { get; set; } = new List<IncomingMaterialDataDetail>();

        public List<InsertFileModel> images = new List<InsertFileModel>();

        public List<InsertFileModel> files = new List<InsertFileModel>();

        public string incomingsn { get; set; }

        public string PO { get; set; }

        public string date { get; set; }

        public string remark { get; set; }
    }

    public class InsertFileModel
    {
        public int size { get; set; } = 0;
        public string name { get; set; } = string.Empty;
        public string url { get; set; } = string.Empty;
    }

    public class IncomingMaterialDataDetail
    {
        public int index { get; set; }

        public int itemid { get; set; }

        public int checktype { get; set; }

        public string sn { get; set; }

        public string result { get; set; }

        public double? value { get; set; }

        public double? lowerlimit { get; set; }

        public double? upperlimit { get; set; }
    }
    public class RequestBadIncomingData
    {
        public int section { get; set; }
        public DateTime start { get; set; }
        public DateTime end { get; set; }
        public int product { get; set; }
        public int material { get; set; }
        public string materialid { get; set; }
        public int supplier { get; set; }
        public int type { get; set; }
        public int x_type { get; set; }
        public int top { get; set; }

    }

    public class RequestUpdateIncomingMaterial : RequestIncomingMaterial
    {
        public int id { get; set; }
    }
}
