namespace Siger.Middlelayer.Repository.Entities
{
    /// <summary>
    /// siger_project Entity Model
    /// </summary>   
    public class siger_project: ConfigEntityBase
    {
        /// <summary>
        /// 项目名称
        /// </summary>
        public string title { get; set; }
   
        /// <summary>
        /// 项目描述
        /// </summary>
        public string description { get; set; }
   
        /// <summary>
        /// 创建者 mid 与 _user id 对应
        /// </summary>
        public int mid { get; set; }
   
        /// <summary>
        /// 企业 ID 与 _company id 对应
        /// </summary>
        public string companyid { get; set; }
   
        /// <summary>
        /// 创建日期
        /// </summary>
        public int createtime { get; set; }
   
        /// <summary>
        /// 创建IP
        /// </summary>
        public string ip { get; set; }
   
        /// <summary>
        /// 项目负责人 id 与 _user id 对应
        /// </summary>
        public int dutymid { get; set; }
   
        /// <summary>
        /// 负责该项目的销售 mid 与 _user id 对应
        /// </summary>
        public int salesmid { get; set; }
   
        /// <summary>
        /// 供应商 id 与 _supplier id 对应 作废
        /// </summary>
        public int supplierid { get; set; }
   
        /// <summary>
        /// 初步报价
        /// </summary>
        public int initialquotation { get; set; }
   
        /// <summary>
        /// 最终报价
        /// </summary>
        public int finaloffer { get; set; }
   
        /// <summary>
        /// 项目类型 与 _project_type id 对应
        /// </summary>
        public int typeid { get; set; }
   
        /// <summary>
        /// 进度 作废
        /// </summary>
        public int progress { get; set; }

        /// <summary>
        /// 项目对应的模块
        /// </summary>
        public string modular { get; set; }

        /// <summary>
        /// 语言类型 0 中文 1 英文
        /// </summary>
        public int language { get; set; }

        /// <summary>
        /// dashboard页面
        /// </summary>
        public string dashboard_ids { get; set; } = string.Empty;
    }
}
