﻿namespace Siger.Middlelayer.Repository.Entities
{
    /// <summary>
    /// siger_project_machine Entity Model
    /// </summary>   
    public class siger_project_machine: ConfigEntityBase
    {
       
        /// <summary>
        /// 项目 id 与 _project id 对应
        /// </summary>
        public int projectid { get; set; }

        /// <summary>
        /// 设备标题
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 设备描述
        /// </summary>
        public string description { get; set; } = string.Empty;

        /// <summary>
        /// 创建时间
        /// </summary>
        public int time { get; set; }

        /// <summary>
        /// 创建 ip
        /// </summary>
        public string ip { get; set; } = string.Empty;
   
        /// <summary>
        /// 1->自用；2->出租；3->出借；4->其他在用；5->停用；6->闲置；7->报废 ；8->盘点中 （当前盘点时的状态）
        /// </summary>
        public int current_status { get; set; }

        /// <summary>
        /// creator
        /// </summary>
        public int mid { get; set; }

        /// <summary>
        /// 品牌 id 与 _brandlist id 对应 作废
        /// </summary>
        public int brand { get; set; } = 0;

        /// <summary>
        /// 与 _machine_type id 对应
        /// </summary>
        public int typeid { get; set; }

        /// <summary>
        /// 设备编号
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 出厂编号
        /// </summary>
        public string factory_code { get; set; } = string.Empty;

        /// <summary>
        /// 生产厂商
        /// </summary>
        public string factory { get; set; } = string.Empty;

        /// <summary>
        /// 制造日期
        /// </summary>
        public string made_date { get; set; } = string.Empty;

        /// <summary>
        /// 设备型号
        /// </summary>
        public string model { get; set; } = string.Empty;

        /// <summary>
        /// 
        /// </summary>
        public string image { get; set; } = string.Empty;

        /// <summary>
        /// 设备保存天数
        /// </summary>
        public string savedays { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string savedaycomment { get; set; }

        /// <summary>
        /// 排序（阿拉伯数字大小）
        /// </summary>
        public int sorting { get; set; } = 0;

        public int attribute { get; set; }
        public int attribution { get; set; }

        public int tool_count { get; set; } = 0;

        public int machinelevel { get; set; } = 0;

        /// <summary>
        /// 1NC设备2非NC设备
        /// </summary>
        public int category { get; set; } = 1;

        public string remarks { get; set; } = string.Empty;

        public string asset_code { get; set; } = string.Empty;
    }
}
