﻿using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Siger.Middlelayer.Repository.Entities
{
    public class siger_project_machine_extend : ConfigEntityBase
    {
        public int machine_id { get; set; }

        /// <summary>
        /// Machine Name
        /// </summary>
        public string machine_name { get; set; } = string.Empty;

        /// <summary>
        /// 测试应用产品
        /// </summary>
        public string typical_application { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-内径
        /// </summary>
        public string inside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-外径
        /// </summary>
        public string outside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 径向载荷
        /// </summary>
        public string radial_load { get; set; } = string.Empty;

        /// <summary>
        /// 轴向载荷
        /// </summary>
        public string axial_load { get; set; } = string.Empty;

        /// <summary>
        /// 压力
        /// </summary>
        public string pressure { get; set; } = string.Empty;

        /// <summary>
        /// 转速
        /// </summary>
        public string speed { get; set; } = string.Empty;

        /// <summary>
        /// 温度
        /// </summary>
        public string temperature { get; set; } = string.Empty;

        /// <summary>
        /// 转速
        /// </summary>
        public string rotation { get; set; } = string.Empty;

        /// <summary>
        /// 样本润滑
        /// </summary>
        public string sample_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-润滑
        /// </summary>
        public string oil_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-液压
        /// </summary>
        public string oil_hydraulic { get; set; } = string.Empty;

        /// <summary>
        /// 信号采集
        /// </summary>
        public string signal_monitor { get; set; } = string.Empty;

        /// <summary>
        /// 测试工位
        /// </summary>
        public string position { get; set; } = string.Empty;

        /// <summary>
        /// 设备尺寸
        /// </summary>
        public string machine_size { get; set; } = string.Empty;

        /// <summary>
        /// 设备简称
        /// </summary>
        public string machine_shortname { get; set; } = string.Empty;

        /// <summary>
        /// 负责人
        /// </summary>
        public string responsor { get; set; } = string.Empty;
    }
}
