﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface IProductRouteRepository : IApiConfigRepositoryBase<siger_project_product_route>
    {
        double GetLastProductRouteByName(int pid, string name);
        IPagedCollectionResult<ResponseGetProductRoute> GetPagedRoutesList(int productId, int page,
            int pagesize, int projectId);

        CommonImportResult ImportRoutes(IEnumerable<RouteList> routes, int projectid, int userid);
        siger_project_product_route InsertProductRouteModel(siger_project_product_route model);
    }
}
