﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectLevelRepository : IApiConfigRepositoryBase<siger_project_level>
    {
        IEnumerable<IdTitle> GetProjectListsWithout();

        bool CanDelete(int projectid);

        int InsertAndGetId(string title, int parentid, int levelid, int projectid);

        IEnumerable<string> GetLevelTitles(int id, int projectid);

        CommonImportResult ImportSections(IEnumerable<LevelSectionEntity> sections, int projectid);
    }
}