﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectLevelSectionRepository : IApiConfigRepositoryBase<siger_project_level_section>
    {
        IEnumerable<LevelSectionTree> GetLevelSectionTree(int projectid, int canselected = 0);

        IEnumerable<int> GetLevelSectionMachineIds(int id, int projectid);

        IEnumerable<string> GetLevelSectionTitles(int id, int projectid);

        IEnumerable<int> GetLevelSectionIds(int id, int projectid);

        bool AddLevelSections(List<AddProjectLevelSection> sections, int projectId);

        IEnumerable<LevelSectionTree> GetLevelSectionMachines(int projectid);

        IEnumerable<ResponseIdName> GetSectionIdNamesByLevel(int levelId, int parentId, int projectId);

        IEnumerable<ResponseIdName> GetAllLines(int projectId);

        IEnumerable<siger_project_level_section> GetAccLines(int projectId);
        IEnumerable<siger_project_level_section> GetAccStation(int projectId);
        IEnumerable<siger_project_level_section> GetAccStationByline(int projectId, int line);

        IEnumerable<siger_project_level_section> Getline(int projectId, int line);
        int GetlineId(int station, int projectId);

        List<LevelSectionTree> GetSectionData(int pid, int parentid);

        string GetSectionString(int pid, int sectionid);
        string GetSectionStringByMid(int pid, int machineid);

        int AddLevelSection(siger_project_level_section levelSection);
        List<siger_project_level_section> getAllTreeData(int pid);
        List<ResponseGetSectionTree> GetSectionChildren(List<siger_project_level_section> alltreedata, int parentid,int pid, int maxlevelId);
        List<ResponseGetSectionTree> GetSectionChildrenFromRotation(string condition, string acc_text_value, int right_article_num,
            double right_foot_online, double right_foot_offline, int parentid, int pid, int maxlevelId);
        List<siger_project_level_section> GetSectionFamilyList(int id, int pid);

        int ConvetTitle(string strTile);
        IEnumerable<siger_project_level_section> GetParentLevelSections(int id, int projectid);

    }
}