using System.Collections.Generic;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerAppMessageRepository : ApiConfigRepositoryBase<siger_app_project_message>, ISigerAppMessageRepository
    {
        private readonly ApiConfigDbContext _context;
        public SigerAppMessageRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public int InsertMessage(siger_app_project_message entity)
        {
            _context.siger_app_project_message.Add(entity);
            return _context.SaveChanges();
        }

        public int UpdateMessage(siger_app_project_message entity)
        {
            _context.siger_app_project_message.Update(entity);
            return _context.SaveChanges();
        }

        public int UpdateMessageRange(IEnumerable<siger_app_project_message> entities)
        {
            _context.siger_app_project_message.UpdateRange(entities);
            return _context.SaveChanges();
        }
    }
}
