﻿using System.Linq;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerProjectLineStorageAuthorityRepository : ApiConfigRepositoryBase<siger_project_line_storage_authority>, ISigerProjectLineStorageAuthorityRepository
    {
        private readonly ApiConfigDbContext _context;
        public SigerProjectLineStorageAuthorityRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseGetStorageAuthorities> GetPagedAuth(int storageId, int projectId,
            int page, int pagesize)
        {
            var querylist = from q in _context.siger_project_line_storage_authority
                join se in _context.siger_project_section on q.section_id equals se.id
                join us in _context.siger_project_user on q.user_id equals us.mid
                join cr in _context.siger_project_user on q.creator_id equals cr.mid
                where q.project_id == projectId && q.status == (int) RowState.Valid && q.storage_id == storageId
                select new ResponseGetStorageAuthorities
                {
                    id = q.id,
                    sectionId = q.section_id,
                    sectionName = se.title,
                    create_time = q.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                    create_name = cr.name,
                    manager_auth = q.manage_authority,
                    use_auth = q.use_authority,
                    userId = q.user_id,
                    userName = us.name,
                    work_code = us.work_code
                };

            var totalCount = querylist.Count();
            var entities = querylist.Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ResponseGetStorageAuthorities>(entities, totalCount);
        }

        public ResponseGetStorageAuthorities GetStorageAuthority(int id, int projectId)
        {
            var querylist = from q in _context.siger_project_line_storage_authority
                join se in _context.siger_project_section on q.section_id equals se.id
                join us in _context.siger_user on q.user_id equals us.id
                join cr in _context.siger_user on q.creator_id equals cr.id
                where q.project_id == projectId && q.status == (int)RowState.Valid && q.id == id
                select new ResponseGetStorageAuthorities
                {
                    sectionId = q.section_id,
                    sectionName = se.title,
                    create_time = q.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                    create_name = cr.nickname,
                    manager_auth = q.manage_authority,
                    use_auth = q.use_authority,
                    userId = q.user_id,
                    userName = us.nickname
                };

            return querylist.FirstOrDefault();
        }
    }
}
