﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Repositories.Interface;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerProjectRestTypeRepository : ApiConfigRepositoryBase<siger_project_rest_type>, ISigerProjectRestTypeRepository
    {
        private readonly ApiConfigDbContext _context;
        public SigerProjectRestTypeRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<siger_project_rest_type> GetRestList(int page, int pagesize, int projectId)
        {
            var query = _context.siger_project_rest_type.Where(q => q.status == (int)RowState.Valid && q.projectid == projectId);
            var totalCount = query.Count();
            var entities = query.Skip((page - 1) * pagesize)
                                .Take(pagesize)
                                .AsNoTracking()
                                .ToList();
            return new PagedCollectionResult<siger_project_rest_type>(entities, totalCount);
        }
    }
}
