﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Response;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface IToolLifeToolChoiceRepository : ITlmRepositoryBase<siger_project_toollife_tool_choice>
    {
        IEnumerable<ResponseGetToolChoice> GetPagedChoice(int workorder_id, int techId, int count, 
            int projectId);

        IEnumerable<ResponseGetStockFromWms> GetStockFromWms(IEnumerable<string> partNos, int projectId);

        IEnumerable<ResponseGetStockFromWms> GetStockInfoes(IEnumerable<int> choiceIds, int projectId);

        bool OutStock(IEnumerable<int> choiceIds, int projectId, int userId);

        bool InStock(IEnumerable<siger_project_toollife_package> packages, int storage_id, int projectId, int userId);

        IPagedCollectionResult<ResponseGetTechToolList> GetPageList(int techId, int workorder_id, string cutterNumber, int page, int pagesize,
            int toexcel, int projectId);
        bool OutStock(List<siger_project_toollife_tool_choice_summary> choices, int projectId, int userId);
    }
}
