﻿using System;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;

namespace Siger.Middlelayer.TlmRepository.Repositories
{
    internal class ToollifeCabinetReceiveDetailRepository : TlmRepositoryBase<SigerProjectToollifeCabinetReceiveDetail>, IToollifeCabinetReceiveDetailRepository
    {
        private readonly ApiTlmDbContext _context;
        public ToollifeCabinetReceiveDetailRepository(ApiTlmDbContext context) : base(context)
        {
            _context = context;
        }

        public int InsertCabinetReceiveDetailData(SigerProjectToollifeCabinetReceiveDetail data)
        {
            try
            {
                _context.siger_project_toollife_cabinet_receive_detail.Add(data);
                return _context.SaveChanges();
            }
            catch (Exception e)
            {
                Logger.WriteLineError(e.Message);
                return 0;
            }
        }
    }
}
