﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.TlmRepository.Response
{
    public class ResponeToollifeDetectionRecord
    {
        public int stock_id { get; set; }
        /// <summary>
        /// 库位名称
        /// </summary>
        public string location { get; set; } = "";
        /// <summary>
        /// 储位
        /// </summary>
        public int storage_location_id { get; set; }
        /// <summary>
        /// 仓库
        /// </summary>
        public int storageid { get; set; }
        /// <summary>
        /// 类别
        /// </summary>
        public string category_name { get; set; }
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier_name { get; set; }
        /// <summary>
        /// 物料名称
        /// </summary>
        public string material_name { get; set; }
        public int material_id { get; set; }
        /// <summary>
        /// 料号
        /// </summary>
        public string part_no { get; set; }
        /// <summary>
        /// 状态1待检测2检测完成3待测试4测试完成
        /// 1和2检测
        /// 3和4测试
        /// </summary>
        public TlmDetectionState state { get; set; }
        /// <summary>
        /// 1需要测试2不需要测试
        /// </summary>
        public int need_test { get; set; }
        public int tool_id { get; set; }
        public DateTime in_time { get; set; }
        /// <summary>
        /// 检测单号
        /// </summary>
        public string OrderNumber { get; set; }
        public int need_detection { get; set; }
        public int category_id { get; set; }
        /// <summary>
        /// 刀具编号
        /// </summary>
        public string tool_number { get; set; }
        /// <summary>
        /// 刀具名
        /// </summary>
        public string tool_name { get; set; }
        /// <summary>
        /// 检测人mid
        /// </summary>
        public int inspector { get; set; }
        /// <summary>
        /// 检测人
        /// </summary>
        public string inspector_name { get; set; }
        /// <summary>
        /// 检测时间
        /// </summary>
        public long inspect_time { get; set; }
        /// <summary>
		/// 结果0未测试1合格2不合格
		/// </summary>
        public int result { get; set; }
        /// <summary>
		/// 结果0未测试1合格2不合格
		/// </summary>
        public string test_result { get; set; } = "";
        /// <summary>
        /// 退货原因
        /// </summary>
        public string reason { get; set; } = "";
        /// <summary>
        /// 退货时间
        /// </summary>
        public DateTime return_time { get; set; } = default(DateTime);
        /// <summary>
        /// 配置类型1刀具2刀柄3附件
        /// </summary>
        public TlmSettingCategory ToolType { get; set; }
        public managemodel manage_model { get; set; }
        /// <summary>
        /// wms唯一编号
        /// </summary>
        public string serial_number { get; set; }
    }

    public class ResponeToollifeDetectionDetail
    {
        /// <summary>
		/// id
		/// </summary>
        public int Id { get; set; }
        public int Status { get; set; }
        public int Creator { get; set; }
        public int Editor { get; set; }
        public DateTime CreateTime { get; set; }
        public string OrderNumber { get; set; }
        public string Seq { get; set; }
        /// <summary>
        /// 检测类型
        /// </summary>
        public string Type { get; set; }
        /// <summary>
        /// 检测工具
        /// </summary>
        public string Tools { get; set; }
        /// <summary>
        /// 标准值
        /// </summary>
        public string StandardValues { get; set; }
        /// <summary>
        /// 上限
        /// </summary>
        public double Max { get; set; }
        /// <summary>
        /// 下限
        /// </summary>
        public double Mini { get; set; }
        /// <summary>
        /// 刀具编号
        /// </summary>
        public string ToolId { get; set; }
        /// <summary>
        /// 配置类型1刀具2刀柄3附件
        /// </summary>
        public TlmSettingCategory ToolType { get; set; }
        /// <summary>
        /// 检测值
        /// </summary>
        public string ActualValue { get; set; }
        /// <summary>
        /// 结果1合格2不合格
        /// </summary>
        public int result { get; set; }
        public int stock_id { get; set; }
        /// <summary>
        /// 库位名称
        /// </summary>
        public string location { get; set; } = "";
    }
}
