using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_project_tool_blx Entity Model
    /// </summary>   
    public class SigerProjectToolBlx : ToolEntityBase
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int id { get; set; }
   
        /// <summary>
        /// 公司ID
        /// </summary>
        public int company_id { get; set; }
   
        /// <summary>
        /// 项目ID
        /// </summary>
        public int project_id { get; set; }
   
        /// <summary>
        /// 设备ID
        /// </summary>
        public int machine_id { get; set; }
   
        /// <summary>
        /// 主轴ID（名称，非外键）
        /// </summary>
        public string spindle_name { get; set; }
   
        /// <summary>
        /// 程序号
        /// </summary>
        public string program_no { get; set; }
   
        /// <summary>
        /// 开始学习时间
        /// </summary>
        public int start_time { get; set; }
   
        /// <summary>
        /// 结束学习时间
        /// </summary>
        public int end_time { get; set; }
   
        /// <summary>
        /// 状态：1有效  0无效
        /// </summary>
        public int status { get; set; }
   
        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; }
   
        /// <summary>
        /// 更新时间
        /// </summary>
        public int update_time { get; set; }
    }
}
