
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_tool_list_total Entity Model
    /// </summary>   
    public class SigerToolListTotal : ToolEntityBase
    {
        /// <summary>
        /// 设备id
        /// </summary>
        [Key]
        public int mid { get; set; }
   
        /// <summary>
        /// 设备标题
        /// </summary>
        public string title { get; set; }
   
        /// <summary>
        /// 设备编号
        /// </summary>
        public string CODE { get; set; }
   
        /// <summary>
        /// 项目 id 与 _project id 对应
        /// </summary>
        public int projectid { get; set; }
   
        /// <summary>
        /// 主轴名称
        /// </summary>
        public string spindle_name { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int location_id { get; set; }
   
        /// <summary>
        /// 刀位名称
        /// </summary>
        public string tool_location_name { get; set; }
   
        /// <summary>
        /// 刀具名称
        /// </summary>
        public string tool_name { get; set; }
   
        /// <summary>
        /// 产品图纸号
        /// </summary>
        public string drawingcode { get; set; }
   
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }
    }
}
